/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.engine.activity.remote.sdk;

import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.Result;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkAggreCrashLogDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashLogDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashLogDetailDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkCrashOverviewDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkModeDeviceAggreDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkOsInfoAggreDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkVersionAggreDTO;
import cn.com.duiba.tuia.ssp.center.api.query.SdkAggreCrashLogQuery;
import cn.com.duiba.tuia.ssp.center.api.query.SdkCrashLogQuery;
import cn.com.duiba.tuia.ssp.center.api.remote.sdk.RemoteSdkCrashLogService;
import cn.com.duiba.tuia.ssp.center.api.tool.RemoteExcuteTemplateHandle;
import cn.com.duiba.tuia.utils.JsonUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SdkCrashLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RemoteSdkCrashLogService remoteSdkCrashLogService;

    public PageResultDto<SdkCrashLogDTO> listSdkCrashLog(SdkCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listSdkCrashLog(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u5d29\u6e83\u65e5\u5fd7\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return (PageResultDto)result.getData();
    }

    public SdkCrashLogDetailDTO crashLogDetail(Long crashLogId) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.sdkCrashLogDetail(crashLogId), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogId));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u5d29\u6e83\u65e5\u5fd7\u8be6\u60c5\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return (SdkCrashLogDetailDTO)result.getData();
    }

    public void resolveAction(Long crashLogId) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.resolveAction(crashLogId), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogId));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u5d29\u6e83\u65e5\u5fd7\u5904\u7406\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
    }

    public void resolveActionV2(List<Long> sdkLogIds, Integer status) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.resolveActionV2(sdkLogIds, status), (Logger)this.logger, (String)JSONObject.toJSONString(sdkLogIds));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u5d29\u6e83\u65e5\u5fd7\u5904\u7406 V2\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
    }

    public SdkCrashOverviewDTO overview(SdkCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.overview(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u5f02\u5e38\u6982\u89c8\u548c\u8d8b\u52bf\u7ebf\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return (SdkCrashOverviewDTO)result.getData();
    }

    public void insertSdkCrashLog(SdkCrashLogDTO sdkCrashLogDTO) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.insertSdkCrashLog(sdkCrashLogDTO), (Logger)this.logger, (String)JsonUtils.objectToString((Object)sdkCrashLogDTO));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("\u63d2\u5165 sdk \u5d29\u6e83\u4fe1\u606f\uff0c\u8bf7\u6c42\u5931\u8d25\uff0cappId:" + sdkCrashLogDTO.getAppId()));
    }

    public Result<PageResultDto<SdkAggreCrashLogDTO>> listAggreSdkCrashLog(SdkCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listAggreSdkCrashLog(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u805a\u5408\u5d29\u6e83\u65e5\u5fd7\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }

    public Result<PageResultDto<SdkVersionAggreDTO>> listAggreSdkVersion(SdkAggreCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listAggreSdkVersion(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u805a\u5408\u7248\u672c\u4fe1\u606f\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }

    public Result<PageResultDto<SdkModeDeviceAggreDTO>> listAggreSdkModeDevice(SdkAggreCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listAggreSdkModeDevice(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u805a\u5408\u673a\u578b\u4fe1\u606f\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }

    public Result<PageResultDto<SdkOsInfoAggreDTO>> listAggreSdkOsInfo(SdkAggreCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listAggreSdkOsInfo(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u805a\u5408\u7cfb\u7edf\u4fe1\u606f\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }

    public Result<PageResultDto<SdkCrashLogDTO>> listSdkCrashLogByIds(SdkAggreCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.listSdkCrashLogByIds(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u67e5\u770b\u66f4\u591a\u8bb0\u5f55\u5217\u8868\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }

    public Result<SdkAggreCrashLogDTO> aggreDetail(SdkAggreCrashLogQuery crashLogQuery) {
        Result result = RemoteExcuteTemplateHandle.execute(() -> this.remoteSdkCrashLogService.aggreSdkCrashLog(crashLogQuery), (Logger)this.logger, (String)JSONObject.toJSONString((Object)crashLogQuery));
        Assert.isTrue((result != null && result.isSuccess() ? 1 : 0) != 0, (String)("SDK \u67e5\u770b\u805a\u5408\u65e5\u5fd7\u8bb0\u5f55\u8be6\u60c5\uff0c\u67e5\u8be2\u5931\u8d25\uff0cerrMsg:" + result.getDesc()));
        return result;
    }
}

