package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: PushMessageEnum.java , v 0.1 2018/5/24 下午5:26 ZhouFeng Exp $
 */
public enum PushMessageEnum {

    /**
     * 好玩tab红点通知
     */
    HAOWAN_POINT(1, "redPoint"),

    /**
     * 邀请零钱奖励通知
     */
    INVITE_CHANGE_REWARD(2, "inviteChangeReward"),;


    private Integer code;

    private String content;


    PushMessageEnum(Integer code, String content) {
        this.code = code;
        this.content = content;
    }

    private static final Map<Integer, PushMessageEnum> CACHE = Maps.uniqueIndex(Arrays.asList(PushMessageEnum.values()),
            PushMessageEnum::getCode);

    public static PushMessageEnum of(Integer code) {
        return CACHE.get(code);
    }


    public Integer getCode() {
        return code;
    }

    public String getContent() {
        return content;
    }
}
