package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.Response.LuckPacketOpenRsp;
import cn.com.duiba.tuia.news.center.dto.Response.LuckPacketReadyResponse;
import cn.com.duiba.tuia.news.center.dto.Response.LuckPacketRsp;
import cn.com.duiba.tuia.news.center.dto.Response.ReceiveLuckPacketRsp;
import cn.com.duiba.tuia.news.center.dto.rsp.LuckPacketIncomeAllRsp;

import java.util.List;

/**
 * Created by xiaotian on 2018/7/19.
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteLuckPacketService {


    /**
     * 获取预发出的红包金额和红包数
     * @param userId
     * @return
     */
    LuckPacketReadyResponse getReadySendRsp(Long userId);


    /**
     * 确认发出红包
     * @param userId
     * @return
     */
    Long deliverpacket(Long userId,String redisKey,String content) throws BizException;


    /**
     * 获取红包状态
     * @param packetId
     * @param code
     * @return
     */
    LuckPacketRsp getPacketCondition(Long packetId, String code);



    /**
     * 根据红包Id获取帮助列表
     * @param packetId
     * @return
     */
    List<LuckPacketOpenRsp> getOpenRecord(Long packetId, String code);


    /**
     * 获取用户的收益列表
     * @param userId
     * @return
     */
    LuckPacketIncomeAllRsp getIncomeList(Long userId, Long pageNo, Long pageSize);


    /**
     * 开启拼手气红包
     * @param packetId
     * @param code
     * @return
     */
    ReceiveLuckPacketRsp receivePacket(Long packetId, String code) throws BizException;


    /**
     * 判断是否是老用户
     * @param userId
     * @param orderId
     * @return
     */
    boolean changeOld(Long userId,Long orderId);



}
