package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.ArticleNumberDto;
import cn.com.duiba.tuia.news.center.dto.MediaAccountTagsDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountStatusDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteMeidaAccountService {

    /**
     * 分页查询自媒体账号信息
     * @param mediaAccountQueryDto 分页对象
     * @return 自媒体用户分页信息
     */
    PageQueryResultDto<MediaAccountDto> pageQuery(MediaAccountQueryDto mediaAccountQueryDto);

    /**
     * 批量更新自媒体冻结状态
     * @param mediaAccountStatusDto 状态对象 ids 不能为null
     */
    boolean batchUpdateStatus(MediaAccountStatusDto mediaAccountStatusDto);

    /**
     * 新增、更新自媒体信息
     * @param mediaAccountDto 自媒体信息dto
     */
    boolean save(MediaAccountDto mediaAccountDto);

    /**
     * 根据自媒体账号Id获取自媒体信息
     * @param id 自媒体账号
     * @return 自媒体信息
     */
    MediaAccountDto selectById(Long id);

    /**
     * 单个更新自媒体冻结状态
     * @param mediaAccountStatusDto 自媒体状态Dto id不能为null
     */
    boolean updateStatus(MediaAccountStatusDto mediaAccountStatusDto);

    /**
     * 根据账号名称查询账号是否已存在
     * @param account 账号
     */
    boolean selectByAccount(String account);

    /**
     * 根据自媒体Ids 批量查询用户信息
     * @param ids 自媒体id列表
     * @return 自媒体列表
     */
    List<MediaAccountDto> selectByIds(List<Long> ids);

    /**
     * 自媒体平台根据账号查询自媒体信息
     * @param account 账号
     * @return 自媒体信息
     */
    MediaAccountDto selectByAccountForLogin(String account);

    /**
     * 根据标签查询账号id列表
     * @param tags
     * @return
     */
    List<Long> selectListLikeTags(String tags);

    /**
     * 根据账号名称查询账号Id
     * @param nickName
     * @return
     */
    List<Long> selectListLikeNickName(String nickName);


    /**
     * 根据账号Ids,获取对应的标签
     */
    List<MediaAccountTagsDto>  selectMediaAccountTagsByIds(List<Long> ids);

    /**
     * 每当发布、下线文章实时更新代理以及自媒体账号的文章数
     */
    void updateArticleNumber(List<ArticleNumberDto>  articleNumberDtos);


    /**
     * 根据代理商id查询所有子账号id
     */
    List<Long> selectSubAccountIdsByAgentIds(List<Long> ids);

    /**
     * 下线代理时批量下线自媒体时，重置子账号发布文章数量
     */
    void  restSubAccountArticleCount(List<Long> agentId);

    /**
     * 自媒体下线状态为冻结+下线文章，重置自媒体发布文章数量
     */
    void restWeMediaAccountArticleCount(List<Long> accountId);
}
