/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ObjectRewardEnum {
    COIN("coin"),
    FARM("landpacket"),
    ARTICLEDOUBLE("articleDouble"),
    TREEDOUBLE("treeDouble"),
    SIGNDOUBLE("signDouble"),
    LOTTERY_TICKET("lotteryTicket");

    private String code;
    private static final Map<String, ObjectRewardEnum> CACHE;

    private ObjectRewardEnum(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static ObjectRewardEnum getByCode(String code) {
        return CACHE.get(code);
    }

    public static ObjectRewardEnum getByInput(String code) {
        return Arrays.stream(ObjectRewardEnum.values()).filter(objectRewardEnum -> code.startsWith(objectRewardEnum.getCode())).findFirst().orElse(null);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ObjectRewardEnum.values()), ObjectRewardEnum::getCode);
    }
}

