package cn.com.duiba.tuia.news.center.dto.req;

import cn.com.duiba.tuia.news.center.enums.message.MessageCode;
import com.google.common.collect.Maps;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * 用户信息的配置
 * @author lichao 2018/11/28
 */
public class UserMessagePush implements Serializable {

    //用户id
    private Long userId;

    //消息的code
    private MessageCode messageCode;

    //消息内容 ^分割
    private String nativeMessage;

    //推送使用的其他参数
    private Map<String,Object> extra;

    //兼容老版本需要的参数,此参数会和path page params 平级
    private Map<String,String> oldParams;

    //消息创建时间
    private Date gmtCreate;

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public UserMessagePush() {
    }

    public UserMessagePush(Long userId, MessageCode messageCode, String nativeMessage) {
        this.userId = userId;
        this.messageCode = messageCode;
        this.nativeMessage = nativeMessage;
    }

    public void addData(String key,Object value){
        if(extra==null){
            extra = Maps.newHashMap();
        }
        extra.put(key,value);
    }

    public void addOldParams(String key,String value){
        if(oldParams==null){
            oldParams = Maps.newHashMap();
        }
        oldParams.put(key,value);
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public MessageCode getMessageCode() {
        return messageCode;
    }

    public void setMessageCode(MessageCode messageCode) {
        this.messageCode = messageCode;
    }

    public String getNativeMessage() {
        return nativeMessage;
    }

    public void setNativeMessage(String nativeMessage) {
        this.nativeMessage = nativeMessage;
    }


    public Map<String, Object> getExtra() {
        return extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public Map<String, String> getOldParams() {
        return oldParams;
    }

    public void setOldParams(Map<String, String> oldParams) {
        this.oldParams = oldParams;
    }
}
