package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.MessageTemplateDto;
import cn.com.duiba.tuia.news.center.dto.req.DistinctContactsReq;
import cn.com.duiba.tuia.news.center.dto.req.InviteMessageReqDto;
import cn.com.duiba.tuia.news.center.dto.rsp.InviteContactInfoDto;
import cn.com.duiba.tuia.news.center.enums.ShortMessageType;

import java.util.List;

/**
 * @author wsz
 * @date 2018/12/10 10:36
 */
@AdvancedFeignClient
public interface RemoteInviteSMService {
    /**
     * 通讯录去重
     */
    List<InviteContactInfoDto> getDistinctContacts(DistinctContactsReq req);

    /**
     * 发送邀请短信
     */
    void sendInviteMessage(InviteMessageReqDto reqDto);

    /**
     * 随机获取多个已发短信手机号
     * @param userId
     * @param num 手机号数量
     */
    List<String> getRandomTextedPhoneNum(Long userId, Integer num);

    /**
     * 检查用户通讯录保存上限，防止通信录上传接口被刷
     */
    Boolean checkAndUpdateUserContactsCeiling(Long userId, Integer addNumber);

    /**
     * 获取随机短信文案
     */
    String getRandomMessageContent(Long userId, ShortMessageType shortMessageType);

    /**
     * 根据类型查询短信模板列表
     */
    List<MessageTemplateDto> selectMessageTemplateList(ShortMessageType shortMessageType);

    /**
     * 保存短信模板
     */
    Boolean saveMessageTemplate(List<MessageTemplateDto> list);

    /**
     * 删除短信模板
     */
    Boolean deleteMessageTemplate(Long id);
}
