package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AccountBalanceDto;
import cn.com.duiba.tuia.news.center.dto.AccountDetailDto;
import cn.com.duiba.tuia.news.center.dto.UserDailyIncomeCoinsDto;
import cn.com.duiba.tuia.news.center.dto.rsp.AccountBalanceV2Dto;
import cn.com.duiba.tuia.news.center.dto.simplePlay.ListReq;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayAddReq;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayAddRsp;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayReadRsp;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayRewardReq;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayRewardRsp;
import cn.com.duiba.tuia.news.center.dto.simplePlay.SimplePlayUpdateSortReq;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteAccountService.java , v 0.1 2018/1/3 下午2:18 ZhouFeng Exp $
 */
@AdvancedFeignClient
public interface RemoteSimplePlayService {


    /**
     *  增加或者更新
     * @param simplePlayAddReq
     * @return
     */
   boolean addOrUpdate(SimplePlayAddReq simplePlayAddReq);


    /**
     * 更改状态
     * @param id
     * @param status
     * @return
     */
   boolean changeStatus(Long id,Integer status);


    /**
     * 获取列表
     * @param versionStart
     * @return
     */
   List<SimplePlayAddRsp> getList(Long versionStart,Integer pageNo,Integer pageSize);


    /**
     * 获取列表(管理端)
     * @return
     */
    List<SimplePlayAddRsp> getListForManager(ListReq listReq);


    /**
     * 拖动排序
     * @param simplePlayUpdateSortReq
     * @return
     */
   boolean updateSort(SimplePlayUpdateSortReq simplePlayUpdateSortReq);



    /**
     * 根据
     * @param level
     * @return
     */
    List<String> getFictionUrlByLevel(Integer level);


    /**
     * 根据Id获取简单赚对象
     * @param id
     * @return
     */
    SimplePlayAddRsp getSimpleById(Long id);

    /**
     * 根据用户Id和简单赚Id获取奖励
     * @return
     */
    SimplePlayRewardRsp getRewardById(SimplePlayRewardReq simplePlayRewardReq);



    /**
     * 根据当前页面的url获取显示的文案
     * @param userId
     * @param url
     * @return
     */
    SimplePlayReadRsp getRewardContent(Long userId, Long id, String url);


}
