package cn.com.duiba.tuia.pangea.center.api.constant;

import lombok.Getter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuantong
 * @version 1.0
 * @since 2019-09-10 18:12
 */
public enum MediaTypeEnum {

    MEDIA((byte) 0, "账号维度"),
    APP((byte) 1, "媒体维度"),
    SLOT((byte) 2, "广告位维度");


    MediaTypeEnum(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static final Map<Byte, MediaTypeEnum> MEDIA_TYPE_MAP;

    static {
        Map<Byte, MediaTypeEnum> temp = new HashMap<>(MediaTypeEnum.values().length, 1);
        for (MediaTypeEnum tag : MediaTypeEnum.values()) {
            temp.put(tag.code, tag);
        }
        MEDIA_TYPE_MAP = Collections.unmodifiableMap(temp);
    }

    @Getter
    private Byte code;
    @Getter
    private String desc;
}
