package cn.com.duiba.tuia.pangea.center.api.req.apollo;

import cn.com.duiba.tuia.pangea.center.api.req.BaseQueryReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿波罗盘古key-value
 *
 * @author wangzhanjin
 * @email
 * @date 2020-07-21 14:46:33
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class ApolloKeyValueReq extends BaseQueryReq implements Serializable {
    private static final long serialVersionUID = 5510803986440442281L;

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "0为专项定制，其他需要列表处理json校验：1为媒体，2为广告位，3为活动，4皮肤，5广告（待定）")
    private Integer keyType;
    private String ownerNames;

    @ApiModelProperty(value = " 配置key名称")
    private String keyName;
    
    @ApiModelProperty(value = " 配置的描述，使用方法")
    private String keyDesc;
    
    @ApiModelProperty(value = " 配置的cf链接")
    private String keyCfUrl;
    
    @ApiModelProperty(value = " 配置key的关键字，唯一")
    private String keyStr;
    
    @ApiModelProperty(value = " 配置key对应的value值，type>0都是json")
    private String keyValueJson;

    private String keyIdMapStr;

    @ApiModelProperty(value = " 当前配置的开关，默认1开，0关")
    private Integer keyOnOff;
    
    @ApiModelProperty(value = " 默认1，白名单1，黑名单2")
    private Integer whiteBlack;
    
    @ApiModelProperty(value = " 当前创建人的信息")
    private String adminId;
    
    @ApiModelProperty(value = " 下线时间，待定")
    private Date offlineTime;
    
    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;
    
    @ApiModelProperty(value = " 修改时间，强删表，有历史表")
    private Date gmtModified;
}
