package cn.com.duiba.tuia.pangea.center.api.req.newactivity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel
@Data
public class NewActivityTestAddOrUpdateReq implements Serializable {

    private static final long serialVersionUID = -1369686446737355775L;

    @ApiModelProperty(value = "测试计划名称", required = true, dataType = "string")
    private String planName;

    @ApiModelProperty(value = "测试计划ID")
    private Long planId;

    @ApiModelProperty(value = "测试计划开始时间", required = true)
    private String startTime;

    @ApiModelProperty(value = "测试计划结束时间", required = true)
    private String endTime;

    @ApiModelProperty(value = "测试人", required = true)
    private String testName;

    @ApiModelProperty(value = "测试人adminId")
    private Long adminId;

    @ApiModelProperty(value = "分流广告位ID列表")
    private List<Long> slotIds;

    @ApiModelProperty(value = "测试类型，默认0：活动ABTest，1：浮标，2：下拉，3：返回拦截，11：响应式插件，21：弹层", required = true)
    private Integer testType;

    @ApiModelProperty(value = "是否是追加投放，1：是， null或0：否")
    private Integer testAddMore;

    @ApiModelProperty(value = "测试组配置")
    private List<PlanTestActivityReq> testGroupList;
}
