/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu;

import cn.com.duiba.tuia.pangea.center.api.dto.apollo.ApolloKeyValueDTO;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.com.duiba.tuia.pangea.center.api.remoteservice.RemoteApolloKeyValueService;
import cn.com.duiba.tuia.pangea.center.api.utils.HashAlgorithm;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApolloPanGuServiceImpl
implements ApolloPanGuService {
    private static final Logger log = LoggerFactory.getLogger(ApolloPanGuServiceImpl.class);
    @Resource
    private RemoteApolloKeyValueService remoteApolloKeyValueService;
    @Resource
    private ExecutorService executorService;
    public static String AB_TEST_FLAG = "abtflag";
    public static String AB_TEST_HYTRIX = "abthytrix";
    public static String AB_TEST_NO = "abtno";
    private CacheLoader<String, String> APOLLO_STRING_LOADER = new CacheLoader<String, String>(){

        public String load(String keyStr) {
            log.info("ApolloPgAPOLLO_STRING_LOADER\u7f13\u5b58\u67e5\u8be2_1\uff0ckeyStr\uff0c{}", (Object)keyStr);
            if (StringUtils.isEmpty((String)keyStr)) {
                return "";
            }
            String keyIdMapStr = ApolloPanGuServiceImpl.this.getKeyIdMapStr(keyStr);
            log.info("ApolloPgAPOLLO_STRING_LOADER\u7f13\u5b58\u67e5\u8be2_2\uff0ckeyStr\uff0c{}\uff0ckeyIdMapStr\uff0c{}", (Object)keyStr, (Object)keyIdMapStr);
            return keyIdMapStr;
        }

        public ListenableFuture<String> reload(String keyStr, String oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(keyStr));
            ApolloPanGuServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private LoadingCache<String, String> APOLLO_PANGU_STRING_CACHE = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(20).refreshAfterWrite(60L, TimeUnit.SECONDS).expireAfterWrite(20L, TimeUnit.HOURS).build(this.APOLLO_STRING_LOADER);
    private CacheLoader<String, Map<String, String>> APOLLO_MAP_LOADER = new CacheLoader<String, Map<String, String>>(){

        public Map<String, String> load(@NotNull String keyStr) {
            return ApolloPanGuServiceImpl.this.getStringMapFromRPC(keyStr);
        }

        public ListenableFuture<Map<String, String>> reload(String keyStr, Map<String, String> oldValue) {
            ListenableFutureTask task = ListenableFutureTask.create(() -> this.load(keyStr));
            ApolloPanGuServiceImpl.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private LoadingCache<String, Map<String, String>> APOLLO_PANGU_MAP_CACHE = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(20).refreshAfterWrite(60L, TimeUnit.SECONDS).expireAfterWrite(20L, TimeUnit.HOURS).build(this.APOLLO_MAP_LOADER);

    @Override
    public String getIdMapStrByKeyStr(String keyStr) {
        if (StringUtils.isEmpty((String)keyStr)) {
            log.error("getIdMapStrByKeyStr \u5165\u53c2\u4e3a\u7a7a");
            return null;
        }
        return (String)this.APOLLO_PANGU_STRING_CACHE.getUnchecked((Object)keyStr);
    }

    @Override
    public Map<String, String> getIdMapByKeyStr(String keyStr) {
        if (StringUtils.isEmpty((String)keyStr)) {
            log.error("getIdMapStrByKeyStr \u5165\u53c2\u4e3a\u7a7a");
            return null;
        }
        return (Map)this.APOLLO_PANGU_MAP_CACHE.getUnchecked((Object)keyStr);
    }

    @Override
    public String getIdMapStrByKeyStrResourceId(String keyStr, String resourceId) {
        if (StringUtils.isEmpty((String)keyStr)) {
            log.error("getIdMapStrByKeyStrResourceId \u5165\u53c2\u4e3a\u7a7a");
            return null;
        }
        Map map = (Map)this.APOLLO_PANGU_MAP_CACHE.getUnchecked((Object)keyStr);
        if (MapUtils.isEmpty((Map)map)) {
            return null;
        }
        return (String)map.get(resourceId);
    }

    @Override
    public Boolean getIdMapStrIsOne(String keyStr) {
        if (StringUtils.isEmpty((String)keyStr)) {
            log.error("getIdMapStrByKeyStr \u5165\u53c2\u4e3a\u7a7a");
            return false;
        }
        String unchecked = (String)this.APOLLO_PANGU_STRING_CACHE.getUnchecked((Object)keyStr);
        if (StringUtils.isEmpty((String)unchecked)) {
            return false;
        }
        boolean flag = unchecked.equals("1");
        log.info("ApolloPg\u76d8\u53e4\u914d\u7f6e\uff0cgetIdMapStrIsOne,{}\uff0cboolean\uff0c{}", (Object)keyStr, (Object)flag);
        return flag;
    }

    @Override
    public int getIdMapStrDeviceIdHashFlag(String keyStr, String resourceId, String deviceId, Integer groupNumber) {
        String valueFromApollo = this.getIdMapStrByKeyStrResourceId(keyStr, resourceId);
        if (StringUtils.isEmpty((String)valueFromApollo)) {
            return 0;
        }
        if (!NumberUtils.isNumeric((String)valueFromApollo)) {
            log.error("Apollo\u76d8\u53e4\u914d\u7f6e\uff0c\u6b63\u4ea4\u5206\u6d41\u8fd4\u56de\u975e\u6570\u5b57,\u4e0d\u547d\u4e2d\u5206\u6d41,{}", (Object)valueFromApollo);
            return 0;
        }
        int ratioApollo = Integer.valueOf(valueFromApollo);
        int deviceHashShunt = 0;
        try {
            deviceHashShunt = ApolloPanGuServiceImpl.sGetDeviceHashShunt(keyStr, deviceId, groupNumber, ratioApollo);
        }
        catch (Exception e) {
            log.error("sGetDeviceHashShunt \u5206\u6d41\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return deviceHashShunt;
    }

    public static int sGetDeviceHashShunt(String keyStr, String deviceId, Integer groupNumber, int ratioApollo) {
        int valueHash = ApolloPanGuServiceImpl.sGetHashValue(keyStr, deviceId);
        if (ratioApollo <= 0 || valueHash >= ratioApollo) {
            return 0;
        }
        if (null == groupNumber || groupNumber <= 1) {
            return 1;
        }
        if (ratioApollo >= 100) {
            ratioApollo = 100;
        }
        int step = ratioApollo / groupNumber;
        for (int i = 0; i < groupNumber; ++i) {
            if (step * i > valueHash || valueHash >= step * (i + 1)) continue;
            return i + 1;
        }
        return 0;
    }

    public static int sGetHashValue(String keyStr, String deviceId) {
        String HashStr = DigestUtils.md5Hex((String)(deviceId + keyStr));
        int hash = HashAlgorithm.dekHash(HashStr);
        return (hash < 0 ? -hash : hash) % 100;
    }

    private Map<String, String> getStringMapFromRPC(String keyStr) {
        log.info("ApolloPgGetStringMapFromRPC\u67e5\u8be2\u5165\u53c2_1\uff0ckeyStr\uff0c{}", (Object)keyStr);
        HashMap<String, String> keyIdMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)keyStr)) {
            return keyIdMap;
        }
        String keyIdMapStr = this.getKeyIdMapStr(keyStr);
        if (StringUtils.isEmpty((String)keyIdMapStr)) {
            log.error("ApolloPgGetStringMapFromRPC \u67e5\u8be2\u4e3a\u7a7a\uff0ckeyStr\uff0c{}", (Object)keyStr);
            return keyIdMap;
        }
        log.info("ApolloPgGetStringMapFromRPC\u67e5\u8be2\u7ed3\u679c_2\uff0ckeyStr\uff0c{}\uff0ckeyIdMapStr\uff0c{}", (Object)keyStr, (Object)keyIdMapStr);
        try {
            Map keyIdMapTemp = (Map)JSON.parse((String)keyIdMapStr);
            for (Object key : keyIdMapTemp.keySet()) {
                keyIdMap.put(key + "", keyIdMapTemp.get(key) + "");
            }
        }
        catch (Exception e) {
            log.error("ApolloPgGetStringMapFromRPC \u7f13\u5b58\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        log.info("ApolloPgGetStringMapFromRPC\u67e5\u8be2\u7ed3\u679c_3\uff0ckeyStr\uff0c{}\uff0ckeyIdMap\uff0c{}", (Object)keyStr, (Object)JSON.toJSONString(keyIdMap));
        return keyIdMap;
    }

    private String getKeyIdMapStr(String keyStr) {
        ApolloKeyValueDTO apolloKeyValueDTO = new ApolloKeyValueDTO();
        apolloKeyValueDTO.setKeyStr(keyStr);
        apolloKeyValueDTO.setKeyOnOff(1);
        apolloKeyValueDTO = this.remoteApolloKeyValueService.selectApolloKeyValue(apolloKeyValueDTO);
        return null == apolloKeyValueDTO ? "" : apolloKeyValueDTO.getKeyIdMapStr();
    }

    public static void main(String[] args) {
        ArrayList<Integer> userList = new ArrayList<Integer>();
        for (int i = 0; i < 1000; ++i) {
            int randomUserId = (int)(Math.random() * 1000000.0);
            userList.add(randomUserId);
        }
        System.out.println(userList);
        HashMap mapSck = new HashMap();
        userList.forEach(dto -> {
            Integer dpaActivity = ApolloPanGuServiceImpl.sGetDeviceHashShunt("DPA\u7d20\u67501", dto + "", 2, 50);
            HashSet<Integer> integers = (HashSet<Integer>)mapSck.get(dpaActivity + "");
            if (integers == null) {
                integers = new HashSet<Integer>();
            }
            integers.add((Integer)dto);
            mapSck.put(dpaActivity + "", integers);
        });
        System.out.println("DPA\u7d20\u6750 ---------------------");
        Set sckSet0 = (Set)mapSck.get("0");
        Set sckSet1 = (Set)mapSck.get("1");
        Set sckSet2 = (Set)mapSck.get("2");
        System.out.println("\u672a\u5206\u6d41\uff0c\u547d\u4e2d\u6570\uff1a" + sckSet0.size());
        System.out.println("\u5206\u6d411\uff0c\u547d\u4e2d\u6570\uff1a" + sckSet1.size());
        System.out.println("\u5206\u6d412\uff0c\u547d\u4e2d\u6570\uff1a" + sckSet2.size());
        HashMap mapAct = new HashMap();
        userList.forEach(dto -> {
            Integer dpaActivity = ApolloPanGuServiceImpl.sGetDeviceHashShunt("DPA\u6d3b\u52a82", dto + "", 2, 50);
            HashSet<Integer> integers = (HashSet<Integer>)mapAct.get(dpaActivity + "");
            if (integers == null) {
                integers = new HashSet<Integer>();
            }
            integers.add((Integer)dto);
            mapAct.put(dpaActivity + "", integers);
        });
        System.out.println("DPA\u6d3b\u52a8 ---------------------");
        Set actSet0 = (Set)mapAct.get("0");
        Set actSet1 = (Set)mapAct.get("1");
        Set actSet2 = (Set)mapAct.get("2");
        System.out.println("\u672a\u5206\u6d41\uff0c\u547d\u4e2d\u6570\uff1a" + actSet0.size());
        System.out.println("\u5206\u6d411\uff0c\u547d\u4e2d\u6570\uff1a" + actSet1.size());
        System.out.println("\u5206\u6d412\uff0c\u547d\u4e2d\u6570\uff1a" + actSet2.size());
        System.out.println("DPA\u7d20\u6750\uff0c\u662f\u5426\u5305\u542bDPA\u6d3b\u52a8 --------------------");
        System.out.println("DPA\u7d20\u6750\u5206\u6d411\uff0c\u4e2d\u5305\u542bDPA\u6d3b\u52a8\u5206\u6d410\u7684\u6570\u91cf\uff1a" + actSet1.stream().filter(sckSet0::contains).collect(Collectors.toList()).size());
        System.out.println("DPA\u7d20\u6750\u5206\u6d411\uff0c\u4e2d\u5305\u542bDPA\u6d3b\u52a8\u5206\u6d411\u7684\u6570\u91cf\uff1a" + actSet1.stream().filter(sckSet1::contains).collect(Collectors.toList()).size());
        System.out.println("DPA\u7d20\u6750\u5206\u6d411\uff0c\u4e2d\u5305\u542bDPA\u6d3b\u52a8\u5206\u6d412\u7684\u6570\u91cf\uff1a" + actSet1.stream().filter(sckSet2::contains).collect(Collectors.toList()).size());
    }
}

