/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.web;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.swagger.models.Swagger;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponents;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.PropertySourcedMapping;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;
import springfox.documentation.swagger2.web.HostNameProvider;

@Controller
@ApiIgnore
public class Swagger2Controller {
    public static final String DEFAULT_URL = "/v2/api-docs";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private final String hostNameOverride;
    private final DocumentationCache documentationCache;
    private final ServiceModelToSwagger2Mapper mapper;
    private final JsonSerializer jsonSerializer;

    @Autowired
    public Swagger2Controller(Environment environment, DocumentationCache documentationCache, ServiceModelToSwagger2Mapper mapper, JsonSerializer jsonSerializer) {
        this.hostNameOverride = environment.getProperty("springfox.documentation.swagger.v2.host", "DEFAULT");
        this.documentationCache = documentationCache;
        this.mapper = mapper;
        this.jsonSerializer = jsonSerializer;
    }

    @RequestMapping(value={"/v2/api-docs"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @PropertySourcedMapping(value="${springfox.documentation.swagger.v2.path}", propertyKey="springfox.documentation.swagger.v2.path")
    @ResponseBody
    public ResponseEntity<Json> getDocumentation(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest servletRequest) {
        Swagger swagger;
        String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
        Documentation documentation = this.documentationCache.documentationByGroup(groupName);
        if (documentation == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        UriComponents uriComponents = HostNameProvider.componentsFrom(servletRequest, (swagger = this.mapper.mapDocumentation(documentation)).getBasePath());
        swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swagger), HttpStatus.OK);
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }
}

