@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  pangea-center-api startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and PANGEA_CENTER_API_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\pangea-center-api-0.0.7.jar;%APP_HOME%\lib\wolf-2.2.30.jar;%APP_HOME%\lib\spring-boot-ext-api-1.2.295.jar;%APP_HOME%\lib\spring-web-4.3.19.RELEASE.jar;%APP_HOME%\lib\springfox-swagger-ui-2.7.0.jar;%APP_HOME%\lib\springfox-swagger2-2.7.0.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\commons-lang3-3.6.jar;%APP_HOME%\lib\hibernate-validator-5.4.0.Final.jar;%APP_HOME%\lib\validation-api-2.0.0.Final.jar;%APP_HOME%\lib\hutool-all-4.1.19.jar;%APP_HOME%\lib\lombok-1.6.10.jar;%APP_HOME%\lib\fastjson-1.2.58.jar;%APP_HOME%\lib\activation-1.1.1.jar;%APP_HOME%\lib\antlr-3.4.jar;%APP_HOME%\lib\bsh-2.0b1.jar;%APP_HOME%\lib\cglib-nodep-3.2.6.jar;%APP_HOME%\lib\objenesis-2.6.jar;%APP_HOME%\lib\springfox-swagger-common-2.7.0.jar;%APP_HOME%\lib\springfox-spring-web-2.7.0.jar;%APP_HOME%\lib\reflections-0.9.11.jar;%APP_HOME%\lib\springfox-schema-2.7.0.jar;%APP_HOME%\lib\springfox-spi-2.7.0.jar;%APP_HOME%\lib\springfox-core-2.7.0.jar;%APP_HOME%\lib\guava-18.0.jar;%APP_HOME%\lib\jsr305-3.0.1.jar;%APP_HOME%\lib\caffeine-2.3.5.jar;%APP_HOME%\lib\json-lib-2.4-jdk15.jar;%APP_HOME%\lib\commons-beanutils-1.9.3.jar;%APP_HOME%\lib\commons-cli-1.2.jar;%APP_HOME%\lib\commons-codec-1.10.jar;%APP_HOME%\lib\ezmorph-1.0.6.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\commons-pool-1.6.jar;%APP_HOME%\lib\commons-math3-3.6.1.jar;%APP_HOME%\lib\joda-time-2.9.9.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.2.30.jar;%APP_HOME%\lib\spring-plugin-metadata-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-plugin-core-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-context-4.3.19.RELEASE.jar;%APP_HOME%\lib\spring-aop-4.3.19.RELEASE.jar;%APP_HOME%\lib\spring-beans-4.3.19.RELEASE.jar;%APP_HOME%\lib\spring-expression-4.3.19.RELEASE.jar;%APP_HOME%\lib\spring-core-4.3.19.RELEASE.jar;%APP_HOME%\lib\swagger-models-1.5.13.jar;%APP_HOME%\lib\swagger-annotations-1.5.13.jar;%APP_HOME%\lib\classmate-1.3.4.jar;%APP_HOME%\lib\slf4j-api-1.7.25.jar;%APP_HOME%\lib\mapstruct-1.1.0.Final.jar;%APP_HOME%\lib\jboss-logging-3.3.2.Final.jar;%APP_HOME%\lib\ST4-4.0.4.jar;%APP_HOME%\lib\antlr-runtime-3.4.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-collections-3.2.2.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.2.30.jar;%APP_HOME%\lib\kotlin-stdlib-1.2.30.jar;%APP_HOME%\lib\jackson-annotations-2.8.0.jar;%APP_HOME%\lib\stringtemplate-3.2.1.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\javassist-3.21.0-GA.jar;%APP_HOME%\lib\byte-buddy-1.8.17.jar

@rem Execute pangea-center-api
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %PANGEA_CENTER_API_OPTS%  -classpath "%CLASSPATH%" cn.com.duiba.tuia.pangea.center.Application %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable PANGEA_CENTER_API_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%PANGEA_CENTER_API_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
