/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.util;

import cn.com.duiba.tuia.risk.center.api.common.BatchFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <I, E> Map<I, E> transf(List<E> list, Function<E, I> t) {
        return EntityUtil.listToMap(list, t);
    }

    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<I, E> map = new HashMap<I, E>();
        for (E e : list) {
            map.put(keyFunc.apply(e), e);
        }
        return map;
    }

    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc, Predicate<E> filterFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<I, E> map = new HashMap<I, E>();
        for (E e : list) {
            if (filterFunc.test(e)) continue;
            map.put(keyFunc.apply(e), e);
        }
        return map;
    }

    public static <I, E> List<I> getParam(List<E> list, Function<E, I> t) {
        ArrayList<I> result = new ArrayList<I>();
        for (E e : list) {
            I k = t.apply(e);
            if (k == null) continue;
            result.add(k);
        }
        return result;
    }

    public static <E, I, E1> void setDtoByIdBatch(List<E> list, BatchFunction<E, I, E1> batchFunction) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (batchFunction == null) {
            return;
        }
        for (E dto : list) {
            batchFunction.processIdFromEntity(dto);
        }
        batchFunction.processSelectList();
        batchFunction.processMap();
    }

    public static <E, I, E1, E2> void setDtoByIdBatch(List<E> list, BatchFunction<E, I, E1> batchFunction1, BatchFunction<E, I, E2> batchFunction2) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (batchFunction1 == null) {
            return;
        }
        for (E dto : list) {
            batchFunction1.processIdFromEntity(dto);
            batchFunction2.processIdFromEntity(dto);
        }
        batchFunction1.processSelectList();
        batchFunction1.processMap();
        batchFunction2.processSelectList();
        batchFunction2.processMap();
    }

    public static <E, I, E1, E2, E3> void setDtoByIdBatch(List<E> list, BatchFunction<E, I, E1> batchFunction1, BatchFunction<E, I, E2> batchFunction2, BatchFunction<E, I, E3> batchFunction3) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (batchFunction1 == null) {
            return;
        }
        for (E dto : list) {
            batchFunction1.processIdFromEntity(dto);
            batchFunction2.processIdFromEntity(dto);
            batchFunction3.processIdFromEntity(dto);
        }
        batchFunction1.processSelectList();
        batchFunction1.processMap();
        batchFunction2.processSelectList();
        batchFunction2.processMap();
        batchFunction3.processSelectList();
        batchFunction3.processMap();
    }

    public static <E, I, E1, E2, E3, E4> void setDtoByIdBatch(List<E> list, BatchFunction<E, I, E1> batchFunction1, BatchFunction<E, I, E2> batchFunction2, BatchFunction<E, I, E3> batchFunction3, BatchFunction<E, I, E4> batchFunction4) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (batchFunction1 == null) {
            return;
        }
        for (E dto : list) {
            batchFunction1.processIdFromEntity(dto);
            batchFunction2.processIdFromEntity(dto);
            batchFunction3.processIdFromEntity(dto);
            batchFunction4.processIdFromEntity(dto);
        }
        batchFunction1.processSelectList();
        batchFunction1.processMap();
        batchFunction2.processSelectList();
        batchFunction2.processMap();
        batchFunction3.processSelectList();
        batchFunction3.processMap();
        batchFunction4.processSelectList();
        batchFunction4.processMap();
    }
}

