package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.DwsSlotRiskAllDIDto;
import cn.com.duiba.tuia.risk.center.api.dto.HandleRecord;
import cn.com.duiba.tuia.risk.center.api.dto.RiskReviewDto;
import cn.com.duiba.tuia.risk.center.api.dto.StatisticShowDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqHandleRecord;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqRiskReviewQuery;


/**
 * ClassName: RemoteRiskReviewService <br/>
 * Function: 风控审核相关service. <br/>
 * date: 2018年2月32日 下午9:15:42 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.7
 */
@AdvancedFeignClient
public interface RemoteRiskReviewService {


    /**
     * queryRiskReviewPage:(查询风控审核列表). <br/>
     *
     *
     * @param reqPageQuery the 分页查询信息
     * @return List<DwsSlotRiskAllDIEntity>  审核信息集合
     * @author cdm
     * @since JDK 1.7
     */
    PageResultDto<DwsSlotRiskAllDIDto> queryRiskReviewPage(ReqRiskReviewQuery reqPageQuery);

    /**
     * queryRiskReviewPage:(查询案例列表). <br/>
     *
     *
     * @param reqPageQuery the 分页查询信息
     * @return List<DwsSlotRiskAllDIEntity>  审核信息集合
     * @author cdm
     * @since JDK 1.7
     */
    PageResultDto<DwsSlotRiskAllDIDto> queryExamplePage(ReqRiskReviewQuery reqPageQuery);

    /**
     * selectByPrimaryKey:(根据主键id查询). <br/>
     *
     * @param id
     * @return ActivityEntity
     */
    RiskReviewDto selectByPrimaryKey(Long id);


    /**
     * updateById:(根据主键id更新). <br/>
     * 全部字段更新.<br/>
     *
     * @author cdm
     * @param record
     * @return int
     * @since JDK 1.7
     */
    int updateById(RiskReviewDto dto);



    /**
     * 根据参数查询活动数量
     *
     * @param reqActivityQuery
     * @return
     */
    int insert(RiskReviewDto dto);

    /**
     * 查询审核界面统计数据
     */
    StatisticShowDto selectCountShow(ReqRiskReviewQuery reqPageQuery);


    int updateInExampleByExampleId(Long id);


	PageResultDto<HandleRecord> queryHandleRecord(ReqHandleRecord req);
}
