package cn.com.duiba.tuia.risk.center.api.dto;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 波动分析
*/
@ApiModel
public class RpsWaveAnalysis implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告位名字")
    private String slotName;

    @ApiModelProperty("规则ID")
    private String ruleId;

    @ApiModelProperty("规则名字")
    private String ruleName;

    @ApiModelProperty("分析时段作弊人数")
    private Long cheatNum;

    @ApiModelProperty("分析时段作弊消耗")
    private Long  cheatConsume;

    @ApiModelProperty("分析时段消耗")
    private Long consume;

    @ApiModelProperty("对比时段作弊人数")
    private Long contCheatNum;

    @ApiModelProperty("对比时段作弊消耗")
    private Long  contCheatConsume;

    @ApiModelProperty("对比时段消耗")
    private Long contConsume;

    @ApiModelProperty("作弊人数变化率")
    private BigDecimal cheatNumRate;

    @ApiModelProperty("作弊消耗变化率")
    private BigDecimal  cheatConsumeRate;

    @ApiModelProperty("消耗变化率")
    private BigDecimal consumeRate;

    @ApiModelProperty("作弊消耗变化值")
    private Long cheatConsumeVal;

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Long getCheatNum() {
        return cheatNum;
    }

    public void setCheatNum(Long cheatNum) {
        this.cheatNum = cheatNum;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Long getConsume() {
        return consume;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public Long getContCheatNum() {
        return contCheatNum;
    }

    public void setContCheatNum(Long contCheatNum) {
        this.contCheatNum = contCheatNum;
    }

    public Long getContCheatConsume() {
        return contCheatConsume;
    }

    public void setContCheatConsume(Long contCheatConsume) {
        this.contCheatConsume = contCheatConsume;
    }

    public Long getContConsume() {
        return contConsume;
    }

    public void setContConsume(Long contConsume) {
        this.contConsume = contConsume;
    }

    public BigDecimal getCheatNumRate() {
        return cheatNumRate;
    }

    public void setCheatNumRate(BigDecimal cheatNumRate) {
        this.cheatNumRate = cheatNumRate;
    }

    public BigDecimal getCheatConsumeRate() {
        return cheatConsumeRate;
    }

    public void setCheatConsumeRate(BigDecimal cheatConsumeRate) {
        this.cheatConsumeRate = cheatConsumeRate;
    }

    public BigDecimal getConsumeRate() {
        return consumeRate;
    }

    public void setConsumeRate(BigDecimal consumeRate) {
        this.consumeRate = consumeRate;
    }

    public Long getCheatConsumeVal() {
        return cheatConsumeVal;
    }

    public void setCheatConsumeVal(Long cheatConsumeVal) {
        this.cheatConsumeVal = cheatConsumeVal;
    }
}

