package cn.com.duiba.tuia.risk.center.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * The Class StringTool.
 */
public class StringTool
{
	
    /**
     * The Constructor.
     */
    private StringTool() {}

    /**
	 * 把一个2,44,51,34,123,123,4（都是数字）形式的字符串解析成一个List<Long>.
	 *
	 * @param arrayStr the array str
	 * @return the long list by str
	 */
	public static List<Long> getLongListByStr(String arrayStr)
	{
		if (StringUtils.isBlank(arrayStr))
		{
			return Collections.emptyList();
		}
		String[] array = arrayStr.split(",");
		List<Long> list = new ArrayList<>();
		for (String s : array)
		{
			list.add(Long.valueOf(s));
		}
		return list;
	}
	
	/**
	 * string 转成List<String>.<br>
	 * 分隔符为symbol
	 * 
	 * @param arrayStr the array str
	 * @return 空list或者分隔后的List<string>
	 */
	public static List<String> getStringListByStr(String arrayStr, String symbol)
	{
		
		if (StringUtils.isNotBlank(arrayStr))
		{
			List<String> list = new ArrayList<>();
			String[] array = arrayStr.split(symbol);
			for (String s : array)
			{
				list.add(s);
			}
			return list;
		}
		else
		{
			return Collections.emptyList();
		}
		
	}

	/**
	 * list转成String.<br>
	 * 分隔符为","
	 *
	 * @return the string by list
	 */
	public static <T> String getStringByList(List<T> list) {
		if (!CollectionUtils.isEmpty(list)) {
			StringBuilder builder = new StringBuilder();
			list.forEach(t->builder.append(t + ","));
			return builder.substring(0, builder.length() - 1);
		}
		return StringUtils.EMPTY;
	}
}
