/**
 * 
 */
package cn.com.duiba.tuia.risk.center.api.dto;

import cn.com.duiba.tuia.risk.center.api.common.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: cdm
 * @version: 2016年2月18日 上午9:48:22
 */
@ApiModel
public class PageParam extends BaseDto{


    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    private static final long serialVersionUID = -9052866712359237685L;

    /** 当前页. */
    @ApiModelProperty("当前页码")
    protected Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    @ApiModelProperty("每页条数")
    protected Integer         pageSize ;

    public void forExport() {
    	currentPage = 1;
    	pageSize = 10000;
	}

    public int foreachTime(int total, int pageSize) {
        if (total <= pageSize) return 0;
        int i = total / pageSize;
        int j = total % pageSize;
        return j == 0 ? i : i + 1;
    }


    public PageParam() {
        super();
        pageSize = PAGE_SIZE_10;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
