package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.PunishmentListDto;

import java.util.Collection;
import java.util.List;

@AdvancedFeignClient
public interface RemotePunishmentListService {

    int insert(PunishmentListDto punishmentListDto);

    /*
    批量插入
     */
    int bulkInsert(Collection<PunishmentListDto> punishmentListDtoList);

    int delete(long id);

    int deleteByPunishmentId(String punishmentId);

    /**
     * 批量删除，最多同时10000条
     *
     * @param dateTimestamp 当日零点时间戳
     * @param listType      列表类型
     * @return 成功数
     */
    int deleteBatchByTimestamp(long dateTimestamp, int listType);

    List<PunishmentListDto> queryAll();

    List<PunishmentListDto> query4Page(long dateTimestamp, int listType, long from, long to);

    PunishmentListDto getByPunishmentId(String punishmentId);

    Integer getMaxId();

    List<PunishmentListDto> query4PageById(long dateTimestamp, int listType, long from, long to) ;
}
