package cn.com.duiba.tuia.risk.center.api.dto;

import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.conversions.DateConversion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

/**
* 作弊处理明细表
*/
@ApiModel
public class CheatDealDetailDto implements Serializable {

    private static final long serialVersionUID = 8818425926085289692L;

    /**
    * 主键
    */
    @ApiModelProperty("主键")
    private Long id;

    /**
    * 日期
    */
    @ApiModelProperty("日期")
    @Parsed(field = "日期", defaultNullWrite = "")
    @Convert(conversionClass = DateConversion.class, args = "yyyy-MM-dd")
    private Date curDate;

    /**
    * 大盘总消耗(分)
    */
    @ApiModelProperty("大盘总消耗")
    @Parsed(field = "大盘总消耗", defaultNullWrite = "")
    private Long totalConsume;

    /**
    * 总作弊消耗(分)
    */
    @ApiModelProperty("总作弊消耗")
    @Parsed(field = "总作弊消耗", defaultNullWrite = "")
    private Long cheatConsume;

    /**
    * 总处理消耗(分)
    */
    @ApiModelProperty("总处理消耗")
    @Parsed(field = "总处理消耗", defaultNullWrite = "")
    private Long dealConsume;

    /**
    * 作弊处理率：总处理消耗/总作弊消耗
    */
    @ApiModelProperty("作弊处理率")
    @Parsed(field = "作弊处理率", defaultNullWrite = "")
    private Double cheatDealRate;

    /**
    * 离线处理消耗
    */
    @ApiModelProperty("离线处理消耗")
    @Parsed(field = "离线处理消耗", defaultNullWrite = "")
    private Long offDealConsume;

    /**
    * 离线处理消耗占比：离线处理消耗/总作弊消耗
    */
    @ApiModelProperty("离线处理消耗占比")
    @Parsed(field = "离线处理消耗占比", defaultNullWrite = "")
    private Double offDealRate;

    /**
    * 实时处理消耗
    */
    @ApiModelProperty("实时处理消耗")
    @Parsed(field = "实时处理消耗", defaultNullWrite = "")
    private Long realDealConsume;

    /**
    * 实时处理消耗占比：实时处理消耗/总作弊消耗
    */
    @ApiModelProperty("实时处理消耗占比")
    @Parsed(field = "实时处理消耗占比", defaultNullWrite = "")
    private Double realDealRate;

    /**
    * 最终处理作弊消耗
    */
    @ApiModelProperty("最终处理作弊消耗")
    @Parsed(field = "最终处理作弊消耗", defaultNullWrite = "")
    private Long finalDealConsume;

    /**
    * 导入钟馗作弊消耗
    */
    @ApiModelProperty("导入钟馗作弊消耗")
    @Parsed(field = "导入钟馗作弊消耗", defaultNullWrite = "")
    private Long riskCheatConsume;

    /**
    * 钟馗处理率：最终处理作弊消耗 / 导入到钟馗的作弊消耗
    */
    @ApiModelProperty("钟馗处理率")
    @Parsed(field = "钟馗处理率", defaultNullWrite = "")
    private Double riskDealRate;

    /**
    * 媒体运营多扣消耗
    */
    @ApiModelProperty("媒体运营多扣消耗")
    @Parsed(field = "媒体运营多扣消耗", defaultNullWrite = "")
    private Long moreDealConsume;

    /**
    * 多扣消耗占比：媒体运营多扣作弊消耗/识别总消耗
    */
    @ApiModelProperty("多扣消耗占比")
    @Parsed(field = "多扣消耗占比", defaultNullWrite = "")
    private Double moreDealRate;

    /**
    * 媒体运营少扣消耗
    */
    @ApiModelProperty("媒体运营少扣消耗")
    @Parsed(field = "媒体运营少扣消耗", defaultNullWrite = "")
    private Long lessDealConsume;

    /**
    * 少扣消耗占比：媒体运营少扣作弊消耗/识别总消耗
    */
    @ApiModelProperty("少扣消耗占比")
    @Parsed(field = "少扣消耗占比", defaultNullWrite = "")
    private Double lessDealRate;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setTotalConsume(Long totalConsume) {
        this.totalConsume = totalConsume;
    }

    public Long getTotalConsume() {
        return totalConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setDealConsume(Long dealConsume) {
        this.dealConsume = dealConsume;
    }

    public Long getDealConsume() {
        return dealConsume;
    }

    public void setCheatDealRate(Double cheatDealRate) {
        this.cheatDealRate = cheatDealRate;
    }

    public Double getCheatDealRate() {
        return cheatDealRate;
    }

    public void setOffDealConsume(Long offDealConsume) {
        this.offDealConsume = offDealConsume;
    }

    public Long getOffDealConsume() {
        return offDealConsume;
    }

    public void setOffDealRate(Double offDealRate) {
        this.offDealRate = offDealRate;
    }

    public Double getOffDealRate() {
        return offDealRate;
    }

    public void setRealDealConsume(Long realDealConsume) {
        this.realDealConsume = realDealConsume;
    }

    public Long getRealDealConsume() {
        return realDealConsume;
    }

    public void setRealDealRate(Double realDealRate) {
        this.realDealRate = realDealRate;
    }

    public Double getRealDealRate() {
        return realDealRate;
    }

    public void setFinalDealConsume(Long finalDealConsume) {
        this.finalDealConsume = finalDealConsume;
    }

    public Long getFinalDealConsume() {
        return finalDealConsume;
    }

    public void setRiskCheatConsume(Long riskCheatConsume) {
        this.riskCheatConsume = riskCheatConsume;
    }

    public Long getRiskCheatConsume() {
        return riskCheatConsume;
    }

    public void setRiskDealRate(Double riskDealRate) {
        this.riskDealRate = riskDealRate;
    }

    public Double getRiskDealRate() {
        return riskDealRate;
    }

    public void setMoreDealConsume(Long moreDealConsume) {
        this.moreDealConsume = moreDealConsume;
    }

    public Long getMoreDealConsume() {
        return moreDealConsume;
    }

    public void setMoreDealRate(Double moreDealRate) {
        this.moreDealRate = moreDealRate;
    }

    public Double getMoreDealRate() {
        return moreDealRate;
    }

    public void setLessDealConsume(Long lessDealConsume) {
        this.lessDealConsume = lessDealConsume;
    }

    public Long getLessDealConsume() {
        return lessDealConsume;
    }

    public void setLessDealRate(Double lessDealRate) {
        this.lessDealRate = lessDealRate;
    }

    public Double getLessDealRate() {
        return lessDealRate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

