package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.InterceptPatrolRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.RiskSlotReviewRecordDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.ReqRiskSlotReviewRecord;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRiskSlotReviewRecordService {

    int insert(RiskSlotReviewRecordDto reviewDto);

    List<RiskSlotReviewRecordDto> query(Long advertId);

    int getTotalCount(Long advertId);

    /**
     * @Description: 分页查询广告审核日志信息
     * @Param:
     * @return:
     * @Author: lijian
     * @Date: 2018/10/30
     */
    PageResultDto<RiskSlotReviewRecordDto> queryPageForRecord(ReqRiskSlotReviewRecord param);


    /**
     * 根据广告主id,审核状态 查询广告主篡改次数
     */
    Integer getTotalCountByMaster(Long accountId, Integer reviewStatus, String quarterBeginTime);

    /**
     * 根据广告主id,篡改类型 更新广告主篡改次数
     */
    Integer updateDistortCount(RiskSlotReviewRecordDto dto);

    /**
     * 根据广告主名称,季度开始时间 查询广告主篡改数据
     */
    List<RiskSlotReviewRecordDto> getRecordByMaster(List<String> advertMasters, String quarterBeginTime);

    Integer updateById(RiskSlotReviewRecordDto dto);

    /**
     * 根据广告id，审核状态，是否申述成功  条件 查询最新的一条数据
     *
     * @param advertId
     * @param reviewStatus
     * @param appealStatus
     * @return
     */
    RiskSlotReviewRecordDto getLastRecordByParam(Long advertId, Integer reviewStatus, Integer appealStatus);
}
