package cn.com.duiba.tuia.risk.center.api.dto;/**
 * Created by chengdeman .
 * 18/2/27 .
 */

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;


/**
 * 风控审核表dto
 *
 * @author chengdeman
 * @create 2018-02-27 下午5:34
 **/
public class RiskReviewDtoUseDate implements Serializable{

    private static final long serialVersionUID = 201998635393628729L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 最全宽表主键ID
     */
    private Long  riskAllId;

    /**
     * 日期
     */
    private String curDate;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * APPid
     */
    private Long appId;

    /**
     * APP名称
     */
    private String appName;

    /**
     * 初步审核人
     */
    private String preRiskReviewer;

    /**
     * 初步处理结果
     */
    private Integer preResult;

    /**
     * 初步处理时间
     */
    private Date preResultTime;

    /**
     * 是否需要上级审核
     */
    private Integer isSuperiorReview;

    /**
     * 最终审核结果
     */
    private Integer reviewResult;

    /**
     * 最终审核时间
     */
    private Date reviewResultTime;

    /**
     * 最终审核人，如果不用上报上级就是初级审核人
     */
    private String riskReviewer;

    /**
     * 是否进入案例库;0:否；1：是
     */
    private Integer isInExample;

    /**
     * 审核备注
     */
    private String reviewRemarks;

    /**
     * 系统登录人员
     */
    private String systemRole;

	// 通知媒体运营开关
	private Boolean needNotify;

	// 建议分成比例
	private Integer adviceRate;

	// 通知媒体运营开关时间
	private Date operationTime;

	// 媒体反馈时间
	private Date feedbackTime;

	// 媒体反馈的分成比例
	private Integer finalRate;

	// 媒体反馈备注
	private String mediaMemo;

    public boolean isFinalReview() {
		return reviewResult != null;
	}

	public String resolveProgress() {
    	if (preResultTime == null && reviewResultTime == null && adviceRate == null) {
    		return "待处理";
	    } else if (preResultTime != null && reviewResultTime == null && adviceRate == null) {
    		return "初步处理完成";
	    } else if (donePreFinal() && adviceRate == null && preResultTime.before(reviewResultTime)) {
    		return "最终处理完成";
	    } else if (donePreFinal() && adviceRate == null && preResultTime.after(reviewResultTime)) {
    		return "初步处理完成";
	    } else if (adviceRate != null && finalRate == null) {
    		return "通知媒体运营";
	    } else if (finalRate != null && adviceRate != null) {
    		return "媒体运营反馈";
	    }
	    return "";
	}

	private boolean donePre() {
    	return preResultTime != null;
	}
	private boolean doneFinal() {
    	return reviewResultTime != null;
	}
	private boolean donePreFinal() {
    	return donePre() && doneFinal();
	}


    public String getSystemRole() {
        return systemRole;
    }

    public void setSystemRole(String systemRole) {
        this.systemRole = systemRole;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRiskAllId() {
        return riskAllId;
    }

    public void setRiskAllId(Long riskAllId) {
        this.riskAllId = riskAllId;
    }


    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getPreRiskReviewer() {
        return preRiskReviewer;
    }

    public void setPreRiskReviewer(String preRiskReviewer) {
        this.preRiskReviewer = preRiskReviewer;
    }

    public Integer getPreResult() {
        return preResult;
    }

    public void setPreResult(Integer preResult) {
        this.preResult = preResult;
    }


    public Integer getIsSuperiorReview() {
        return isSuperiorReview;
    }

    public void setIsSuperiorReview(Integer isSuperiorReview) {
        this.isSuperiorReview = isSuperiorReview;
    }

    public Integer getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }


    public String getRiskReviewer() {
        return riskReviewer;
    }

    public void setRiskReviewer(String riskReviewer) {
        this.riskReviewer = riskReviewer;
    }

    public Integer getIsInExample() {
        return isInExample;
    }

    public void setIsInExample(Integer isInExample) {
        this.isInExample = isInExample;
    }

    public String getReviewRemarks() {
        return reviewRemarks;
    }

    public void setReviewRemarks(String reviewRemarks) {
        this.reviewRemarks = reviewRemarks;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

	public Date getPreResultTime() {
		return preResultTime;
	}

	public void setPreResultTime(Date preResultTime) {
		this.preResultTime = preResultTime;
	}

	public Date getReviewResultTime() {
		return reviewResultTime;
	}

	public void setReviewResultTime(Date reviewResultTime) {
		this.reviewResultTime = reviewResultTime;
	}

	public Boolean getNeedNotify() {
		return needNotify;
	}

	public void setNeedNotify(Boolean needNotify) {
		this.needNotify = needNotify;
	}

	public Integer getAdviceRate() {
		return adviceRate;
	}

	public void setAdviceRate(Integer adviceRate) {
		this.adviceRate = adviceRate;
	}

	public Date getOperationTime() {
		return operationTime;
	}

	public void setOperationTime(Date operationTime) {
		this.operationTime = operationTime;
	}

	public Integer getFinalRate() {
		return finalRate;
	}

	public void setFinalRate(Integer finalRate) {
		this.finalRate = finalRate;
	}

	public String getMediaMemo() {
		return mediaMemo;
	}

	public void setMediaMemo(String mediaMemo) {
		this.mediaMemo = mediaMemo;
	}

	public Date getFeedbackTime() {
		return feedbackTime;
	}

	public void setFeedbackTime(Date feedbackTime) {
		this.feedbackTime = feedbackTime;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
