package cn.com.duiba.tuia.risk.center.api.dto.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel("风控域名解析表")
public class RiskDomainAnalysisDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("域名")
    private String domain;

    @ApiModelProperty("域名类型，1：百奇落地页，2：积木落地页")
    private Integer domainType;

    @ApiModelProperty("解析状态，1：解析成功，0：解析失败")
    private Integer analysisStatus;

    @ApiModelProperty("失败原因类型，1:域名解析失败,2:中台配置失败,3:验证失败")
    private Integer reasonType;

    @ApiModelProperty("解析人名称")
    private String analysisName;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomainType(Integer domainType) {
        this.domainType = domainType;
    }

    public Integer getDomainType() {
        return domainType;
    }

    public void setAnalysisStatus(Integer analysisStatus) {
        this.analysisStatus = analysisStatus;
    }

    public Integer getAnalysisStatus() {
        return analysisStatus;
    }

    public void setReasonType(Integer reasonType) {
        this.reasonType = reasonType;
    }

    public Integer getReasonType() {
        return reasonType;
    }

    public void setAnalysisName(String analysisName) {
        this.analysisName = analysisName;
    }

    public String getAnalysisName() {
        return analysisName;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

}

