package cn.com.duiba.tuia.risk.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * 风控广告位导量表
 */
@ApiModel
public class SlotGuideList4Update implements Serializable {

    private static final long serialVersionUID = -2396396655886444980L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("规则ID")
    private String ruleId;

    /**
     * 日期
     */
    private String curDate;

    @ApiModelProperty("发券比例")
    @Range(min = 0, max = 1, message = "发券比例不在范围0-1")
    private Double launchRate;

    /**
     * 广告位前一天的总发券量
     */
    private Long beforeLaunchPv;

    /**
     * 目标发券pv：命中规则对应的发券比例*该广告位前一天的发券量
     */
    private Long targetLaunchPv;

    /**
     * 已完成发券pv
     */
    private Long completedLaunchPv;

    /**
     * 目标完成率：已完成发券pv/目标发券pv
     */
    private Double targetCompleteRate;

    /**
     * 发券概率:目标发券pv/当天首次命中A规则的时间点，前一天该广告位该时间点之后的发券量
     */
    @ApiModelProperty("发券概率")
    @Range(min = 0, max = 1, message = "发券概率不在范围0-1")
    private Double launchChance;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public Double getLaunchRate() {
        return launchRate;
    }

    public void setLaunchRate(Double launchRate) {
        this.launchRate = launchRate;
    }

    public Long getBeforeLaunchPv() {
        return beforeLaunchPv;
    }

    public void setBeforeLaunchPv(Long beforeLaunchPv) {
        this.beforeLaunchPv = beforeLaunchPv;
    }

    public Long getTargetLaunchPv() {
        return targetLaunchPv;
    }

    public void setTargetLaunchPv(Long targetLaunchPv) {
        this.targetLaunchPv = targetLaunchPv;
    }

    public Long getCompletedLaunchPv() {
        return completedLaunchPv;
    }

    public void setCompletedLaunchPv(Long completedLaunchPv) {
        this.completedLaunchPv = completedLaunchPv;
    }

    public Double getTargetCompleteRate() {
        return targetCompleteRate;
    }

    public void setTargetCompleteRate(Double targetCompleteRate) {
        this.targetCompleteRate = targetCompleteRate;
    }

    public Double getLaunchChance() {
        return launchChance;
    }

    public void setLaunchChance(Double launchChance) {
        this.launchChance = launchChance;
    }
}

