package cn.com.duiba.tuia.risk.center.api.dto.domain;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 域名DTO
 *
 * @author peanut.huang
 * @date 2019/10/23
 * @since JDK 1.8
 */
@Data
public class DomainDTO implements Serializable {

    private static final long serialVersionUID = 8977967840091677013L;

    public static final String ANY_INDUSTRY = "-1";

    /**
     * 域名记录id
     */
    private Long id;

    /**
     * 域名地址
     */
    private String domain;

    /**
     * 域名类型 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainTypeEnum}
     */
    private Integer domainType;

    /**
     * 域名状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainStatusEnum}
     */
    private Integer domainStatus;

    /**
     * 域名在微信的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum}
     */
    private Integer wxStatus;

    /**
     * 域名在支付宝安卓的投放状态 {@link cn.com.duiba.tuia.risk.center.api.enums.DomainWXStatusEnum}
     */
    private Integer alipayStatus;

    /**
     * 添加人名称
     */
    private String adminName;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 域名状态更新时间
     */
    private Date statusTime;

    /**
     * 微信状态更新时间
     */
    private Date wxStatusTime;

    /**
     * 支付宝安卓状态更新时间
     */
    private Date alipayStatusTime;

    /**
     * 域名管理策略id::tb_domain_strategy.id 默认0 全局
     */
    private Long strategyId;

    /**
     * 域名被封的url
     */
    private List<String> urls;

    private String icpNo;

    /**新行业标签 -1:不限*/
    private String newTrade;

    /**域名在支付宝IOS的投放状态*/
    private Integer alipayIosStatus;

    /**支付宝IOS状态更新时间*/
    private Date alipayIosStatusTime;

    /**
     * 是否开启域名替换 1.是 0.否
     */
    private Integer replaceDomain;

    /**
     * 是否绑定活动域名 1.是 0.否
     */
    private Integer bindActivityDomainStatus;
    /**
     * 绑定的活动域名
     */
    private String bindActivityDomain;

    /**
     * 是否绑定广告位域名 1.是 0.否
     */
    private Integer bindSlotDomainStatus;
    /**
     * 绑定的广告位域名
     */
    private String bindSlotDomain;
}
