package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.AccountCreditInfoDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.AccountCreditParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountCreditInfoService {

    PageResultDto<AccountCreditInfoDto> queryPage(AccountCreditParam param);

    int save(AccountCreditInfoDto dto);

    int update(AccountCreditInfoDto dto);

    List<AccountCreditInfoDto> listByParam(AccountCreditParam param);

    /**
     * 根据广告主ID更新计算信用分数据
     * @param dto
     * @return
     */
    int updateScoreByAccount(AccountCreditInfoDto dto);

    /**
     * 广告主信用分初始化
     * @return
     */
    Boolean accountCreditScoreInit();

    /**
     * 广告主信用分每日更新
     * @return
     */
    void accountCreditScoreUpdate();
}
