package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.dto.PayRecognitionResultEntity;

import java.util.List;

/**
 * @author Wangpf
 * @date 2023/6/7 11:25 上午
 */
@AdvancedFeignClient
public interface RemotePayRecognitionResultService {

    /**
     * 识别并记录落地页二跳的支付金额
     *
     * @param advertId
     * @param promoteUrl
     * @param jumpUrl
     * @param urlId 落地页ID
     * @return
     */
    boolean payRecognitionResult(Long advertId, String promoteUrl, String jumpUrl, Long urlId);

    /**
     * 识别并记录落地页二跳的支付金额
     *
     * @param advertId
     * @param promoteUrl
     * @param jumpUrls
     * @param urlId 落地页ID
     * @return
     */
    boolean batchPayRecognitionResult(Long advertId, String promoteUrl, Long urlId, List<String> jumpUrls);

    /**
     * 根据广告ID 获取对应的金额识别数据
     *
     * @param advertIds
     * @return
     */
    List<PayRecognitionResultEntity> listByAdvertIds(List<Long> advertIds);


}
