package cn.com.duiba.tuia.risk.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.risk.center.api.common.PageResultDto;
import cn.com.duiba.tuia.risk.center.api.dto.PayRecognitionWordDto;
import cn.com.duiba.tuia.risk.center.api.dto.PayRecognitionWordTagDto;
import cn.com.duiba.tuia.risk.center.api.dto.req.PayRecognitionWordTagReq;

import java.util.List;

/**
 * 支付金额识别-关键词
 *
 * @author Wangpf
 * @date 2023/6/5 11:15 上午
 */
@AdvancedFeignClient
public interface RemotePayRecognitionWordService {

    /**
     * 新增行业
     *
     * @param payRecognitionWordTagDto
     * @return
     */
    boolean tagAdd(PayRecognitionWordTagDto payRecognitionWordTagDto) throws BizException;

    /**
     * 删除行业
     *
     * @param id
     * @return
     */
    boolean tagRemove(Long id);

    /**
     * 新增关键词
     *
     * @param record
     * @return
     */
    boolean wordAdd(PayRecognitionWordDto record);

    /**
     * 删除关键词
     *
     * @param id
     * @return
     */
    boolean wordRemove(Long id);

    PageResultDto<PayRecognitionWordTagDto> queryPage(PayRecognitionWordTagReq recognitionWordTagReq);

    /**
     * 根据行业对应的主键Id 查询对应的关键字
     *
     * @param tagIds
     * @return
     */
    List<PayRecognitionWordDto> listWordByTagIds(List<Long> tagIds);
}
