/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.robot.center.api.domain.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DateUtil {
    public static final String STANDARD_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String STANDARD_DATE_FORMAT = "yyyy-MM-dd";
    public static final String STANDARD_DATE_NO_UNDERLINE_FORMAT = "yyyyMMdd";
    public static final String FULL_DATE = "yyyyMMddHHmmss";

    public static Long getDayOfStart() {
        return DateUtil.getDateline() / 86400L;
    }

    public static Long getDayOfStart(Date date) {
        return date.getTime() / 86400L;
    }

    public static Date startOfTodDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date startOfTodDayTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long startOfTodDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        return date.getTime() / 1000L;
    }

    public static Date endOfDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date endOfDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Map<String, Object> getYearMonthAndDay(int dayUntilNow) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, -dayUntilNow);
        map.put("year", calendar.get(1));
        map.put("month", calendar.get(2) + 1);
        map.put("day", calendar.get(5));
        return map;
    }

    public static Date toDate(String date, String pattern) {
        if ("".equals("" + date)) {
            return null;
        }
        if (pattern == null) {
            pattern = STANDARD_DATE_FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.ENGLISH);
        Date newDate = new Date();
        try {
            newDate = sdf.parse(date);
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return newDate;
    }

    public static Long[] getLastMonth() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        cal.set(5, 1);
        cal.add(5, -1);
        int day = cal.get(5);
        String months = "";
        String days = "";
        if (month > 1) {
            --month;
        } else {
            --year;
            month = 12;
        }
        months = String.valueOf(month).length() <= 1 ? "0" + month : String.valueOf(month);
        days = String.valueOf(day).length() <= 1 ? "0" + day : String.valueOf(day);
        String firstDay = "" + year + "-" + months + "-01";
        String lastDay = "" + year + "-" + months + "-" + days + " 23:59:59";
        Long[] lastMonth = new Long[]{DateUtil.getDateline(firstDay), DateUtil.getDateline(lastDay, STANDARD_FORMAT)};
        return lastMonth;
    }

    public static String toString(Date date) {
        return DateUtil.toString(date, STANDARD_FORMAT);
    }

    public static String toString(Long date) {
        return DateUtil.toString(date, STANDARD_FORMAT);
    }

    public static String toString(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        if (pattern == null) {
            pattern = STANDARD_DATE_FORMAT;
        }
        String dateString = "";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            dateString = sdf.format(date);
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return dateString;
    }

    public static String toString(Long time, String pattern) {
        if (time > 0L) {
            if (time.toString().length() == 10) {
                time = time * 1000L;
            }
            Date date = new Date(time);
            return DateUtil.toString(date, pattern);
        }
        return "";
    }

    public static boolean inRangeOf(long start, long end) {
        long now = DateUtil.getDateline();
        return start <= now && end >= now;
    }

    public static long getDateline(String date) {
        return Objects.requireNonNull(DateUtil.toDate(date, STANDARD_DATE_FORMAT)).getTime() / 1000L;
    }

    public static long getDateline() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getCurrentDateStr(String format) {
        return DateUtil.toString(new Date(), format);
    }

    public static String getCurrentDateStr() {
        return DateUtil.toString(new Date(), FULL_DATE);
    }

    public static long getDateline(String date, String pattern) {
        return Objects.requireNonNull(DateUtil.toDate(date, pattern)).getTime() / 1000L;
    }

    public static long getBeforeMonthDateline(int beforeMonth) {
        SimpleDateFormat format = new SimpleDateFormat(STANDARD_FORMAT);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(2, 0 - beforeMonth);
        Date m = c.getTime();
        String mon = format.format(m);
        return DateUtil.getDateline(mon, STANDARD_FORMAT);
    }

    public static Date getCurrentDayStartTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(13, cal.get(13) - 1);
        return cal.getTime();
    }

    public static Date getCurrentDayEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, cal.get(5) + 1);
        cal.set(13, cal.get(13) - 1);
        return cal.getTime();
    }

    public static Calendar getCleanCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Integer getDelayTime(Long startTime) {
        int time = Math.toIntExact((startTime - System.currentTimeMillis()) / 1000L);
        if (time <= 0) {
            time = 1;
        }
        return time;
    }

    public static Date getBeginTime(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        LocalDate localDate = yearMonth.atDay(1);
        LocalDateTime startOfDay = localDate.atStartOfDay();
        ZonedDateTime zonedDateTime = startOfDay.atZone(ZoneId.of("Asia/Shanghai"));
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date getEndTime(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        LocalDate endOfMonth = yearMonth.atEndOfMonth();
        LocalDateTime localDateTime = endOfMonth.atTime(23, 59, 59, 999);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of("Asia/Shanghai"));
        return Date.from(zonedDateTime.toInstant());
    }
}

