/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.robot.center.api.domain.utils;

import cn.com.duiba.tuia.robot.center.api.domain.utils.BeanUtil;
import cn.com.duiba.tuia.robot.center.api.domain.utils.StringUtils;
import cn.com.duiba.tuia.robot.center.api.domain.vo.PageVO;
import cn.com.duiba.tuia.robot.center.api.domain.vo.SearchVO;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PageUtil {
    public static <T> Page<T> initPage(PageVO page) {
        Page p;
        int pageNumber = page.getPageNumber();
        int pageSize = page.getPageSize();
        String sort = page.getSort();
        String order = page.getOrder();
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        if (StrUtil.isNotBlank((CharSequence)sort)) {
            Boolean isAsc = false;
            if (StrUtil.isBlank((CharSequence)order)) {
                isAsc = false;
            } else if ("desc".equals(order.toLowerCase())) {
                isAsc = false;
            } else if ("asc".equals(order.toLowerCase())) {
                isAsc = true;
            }
            p = new Page((long)pageNumber, (long)pageSize);
            if (isAsc.booleanValue()) {
                p.addOrder(new OrderItem[]{OrderItem.asc((String)sort)});
            } else {
                p.addOrder(new OrderItem[]{OrderItem.desc((String)sort)});
            }
        } else {
            p = new Page((long)pageNumber, (long)pageSize);
        }
        return p;
    }

    public static <T> QueryWrapper<T> initWrapper(Object object) {
        return PageUtil.initWrapper(object, null);
    }

    public static <T> QueryWrapper<T> initWrapper(Object object, SearchVO searchVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (searchVo != null && StrUtil.isNotBlank((CharSequence)searchVo.getStartDate()) && StrUtil.isNotBlank((CharSequence)searchVo.getEndDate())) {
            DateTime start = DateUtil.parse((CharSequence)searchVo.getStartDate());
            DateTime end = DateUtil.parse((CharSequence)searchVo.getEndDate());
            queryWrapper.between((Object)"create_time", (Object)start, (Object)DateUtil.endOfDay((Date)end));
        }
        if (searchVo != null && StrUtil.isNotBlank((CharSequence)searchVo.getInColumn()) && CollectionUtils.isNotEmpty(searchVo.getInColumnValue())) {
            queryWrapper.in((Object)searchVo.getInColumn(), searchVo.getInColumnValue());
        }
        if (object != null) {
            String[] fieldNames;
            String[] var10 = fieldNames = BeanUtil.getFiledName(object);
            int var5 = fieldNames.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String key = var10[var6];
                Object value = BeanUtil.getFieldValueByName(key, object);
                if (value == null || "".equals(value)) continue;
                queryWrapper.eq((Object)StringUtils.camel2Underline(key), value);
            }
        }
        return queryWrapper;
    }

    public static <T> List<T> listToPage(PageVO page, List<T> list) {
        int pageNumber = page.getPageNumber() - 1;
        int pageSize = page.getPageSize();
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        if (pageSize > 100) {
            pageSize = 100;
        }
        int fromIndex = pageNumber * pageSize;
        int toIndex = pageNumber * pageSize + pageSize;
        if (fromIndex > list.size()) {
            return new ArrayList();
        }
        return toIndex >= list.size() ? list.subList(fromIndex, list.size()) : list.subList(fromIndex, toIndex);
    }

    public static <T> Page<T> convertPage(Page originPage, List<T> records) {
        Page resultPage = new Page();
        if (originPage != null) {
            resultPage.setCurrent(originPage.getCurrent());
            resultPage.setPages(originPage.getPages());
            resultPage.setTotal(originPage.getTotal());
            resultPage.setSize(originPage.getSize());
            resultPage.setRecords(records);
        }
        return resultPage;
    }
}

