package cn.com.duiba.tuia.robot.center.api.context;

import cn.com.duiba.tuia.robot.center.api.domain.dto.AuthUser;
import cn.com.duiba.tuia.robot.center.api.domain.enums.CachePrefix;
import cn.com.duiba.tuia.robot.center.api.domain.enums.ResultCode;
import cn.com.duiba.tuia.robot.center.api.domain.enums.SecurityEnum;
import cn.com.duiba.tuia.robot.center.api.domain.utils.Cache;
import cn.com.duiba.tuia.robot.center.api.domain.utils.SecretKeyUtil;
import cn.com.duiba.tuia.robot.center.api.domain.vo.ServiceException;
import cn.hutool.core.text.CharSequenceUtil;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import javax.servlet.http.HttpServletRequest;

public class UserContext {
    public UserContext() {
    }

    public static AuthUser getCurrentUser() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String accessToken = request.getHeader(SecurityEnum.HEADER_TOKEN.getValue());
            return getAuthUser(accessToken);
        } else {
            return null;
        }
    }

    public static String getUuid() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader(SecurityEnum.UUID.getValue());
        } else {
            return null;
        }
    }

    public static AuthUser getAuthUser(Cache cache, String accessToken) {
        try {
            AuthUser authUser = getAuthUser(accessToken);

            assert authUser != null;

            if (!cache.hasKey(CachePrefix.ACCESS_TOKEN.getPrefix(authUser.getRole()) + accessToken)) {
                throw new ServiceException(ResultCode.USER_AUTHORITY_ERROR);
            } else {
                return authUser;
            }
        } catch (Exception var3) {
            return null;
        }
    }

    public static String getCurrentUserToken() {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader(SecurityEnum.HEADER_TOKEN.getValue());
        } else {
            return null;
        }
    }

    public static AuthUser getAuthUser(String accessToken) {
        try {
            Claims claims = (Claims) Jwts.parserBuilder().setSigningKey(SecretKeyUtil.generalKeyByDecoders()).build().parseClaimsJws(accessToken).getBody();
            String json = claims.get(SecurityEnum.USER_CONTEXT.getValue()).toString();
            return (AuthUser)(new Gson()).fromJson(json, AuthUser.class);
        } catch (ExpiredJwtException var3) {
            throw new ServiceException(ResultCode.USER_AUTH_EXPIRED);
        } catch (Exception var4) {
            return null;
        }
    }

    public static void settingInviter(String memberId, Cache cache) {
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String inviterId = request.getHeader(SecurityEnum.INVITER.getValue());
            if (CharSequenceUtil.isNotEmpty(inviterId)) {
                cache.put(CachePrefix.INVITER.getPrefix() + memberId, inviterId);
            }
        }

    }
}

