package cn.com.duiba.tuia.robot.center.api.domain.utils;

import cn.com.duiba.tuia.robot.center.api.domain.vo.PageVO;
import cn.com.duiba.tuia.robot.center.api.domain.vo.SearchVO;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PageUtil {
    public PageUtil() {
    }

    public static <T> Page<T> initPage(PageVO page) {
        int pageNumber = page.getPageNumber();
        int pageSize = page.getPageSize();
        String sort = page.getSort();
        String order = page.getOrder();
        if (pageNumber < 1) {
            pageNumber = 1;
        }

        if (pageSize < 1) {
            pageSize = 10;
        }

        if (pageSize > 100) {
            pageSize = 100;
        }

        Page p;
        if (StrUtil.isNotBlank(sort)) {
            Boolean isAsc = false;
            if (StrUtil.isBlank(order)) {
                isAsc = false;
            } else if ("desc".equals(order.toLowerCase())) {
                isAsc = false;
            } else if ("asc".equals(order.toLowerCase())) {
                isAsc = true;
            }

            p = new Page((long)pageNumber, (long)pageSize);
            if (isAsc) {
                p.addOrder(new OrderItem[]{OrderItem.asc(sort)});
            } else {
                p.addOrder(new OrderItem[]{OrderItem.desc(sort)});
            }
        } else {
            p = new Page((long)pageNumber, (long)pageSize);
        }

        return p;
    }

    public static <T> QueryWrapper<T> initWrapper(Object object) {
        return initWrapper(object, (SearchVO)null);
    }

    public static <T> QueryWrapper<T> initWrapper(Object object, SearchVO searchVo) {
        QueryWrapper<T> queryWrapper = new QueryWrapper();
        if (searchVo != null && StrUtil.isNotBlank(searchVo.getStartDate()) && StrUtil.isNotBlank(searchVo.getEndDate())) {
            Date start = DateUtil.parse(searchVo.getStartDate());
            Date end = DateUtil.parse(searchVo.getEndDate());
            queryWrapper.between("create_time", start, DateUtil.endOfDay(end));
        }

        if (searchVo != null && StrUtil.isNotBlank(searchVo.getInColumn()) && CollectionUtils.isNotEmpty(searchVo.getInColumnValue())) {
            queryWrapper.in(searchVo.getInColumn(), searchVo.getInColumnValue());
        }

        if (object != null) {
            String[] fieldNames = BeanUtil.getFiledName(object);
            String[] var10 = fieldNames;
            int var5 = fieldNames.length;

            for(int var6 = 0; var6 < var5; ++var6) {
                String key = var10[var6];
                Object value = BeanUtil.getFieldValueByName(key, object);
                if (value != null && !"".equals(value)) {
                    queryWrapper.eq(StringUtils.camel2Underline(key), value);
                }
            }
        }

        return queryWrapper;
    }

    public static <T> List<T> listToPage(PageVO page, List<T> list) {
        int pageNumber = page.getPageNumber() - 1;
        int pageSize = page.getPageSize();
        if (pageNumber < 0) {
            pageNumber = 0;
        }

        if (pageSize < 1) {
            pageSize = 10;
        }

        if (pageSize > 100) {
            pageSize = 100;
        }

        int fromIndex = pageNumber * pageSize;
        int toIndex = pageNumber * pageSize + pageSize;
        if (fromIndex > list.size()) {
            return new ArrayList();
        } else {
            return toIndex >= list.size() ? list.subList(fromIndex, list.size()) : list.subList(fromIndex, toIndex);
        }
    }

    public static <T> Page<T> convertPage(Page originPage, List<T> records) {
        Page<T> resultPage = new Page();
        if (originPage != null) {
            resultPage.setCurrent(originPage.getCurrent());
            resultPage.setPages(originPage.getPages());
            resultPage.setTotal(originPage.getTotal());
            resultPage.setSize(originPage.getSize());
            resultPage.setRecords(records);
        }

        return resultPage;
    }
}