package cn.com.duiba.tuia.robot.center.api.domain.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.*;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class RedisCache implements Cache{
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    @Resource
    private RedisTemplate<Object, Object> redisTemplate;

    public List<Object> keys(String pattern) {
        List<Object> keys = new ArrayList();
        this.scan(pattern, (item) -> {
            String key = new String(item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute((RedisCallback<Object>) (connection) -> {
            Cursor<byte[]> cursor = connection.scan(ScanOptions.scanOptions().count(9223372036854775807L).match(pattern).build());
            Throwable var4 = null;

            Object var5;
            try {
                cursor.forEachRemaining(consumer);
                var5 = null;
            } catch (Throwable var14) {
                var4 = var14;
                throw var14;
            } finally {
                if (cursor != null) {
                    if (var4 != null) {
                        try {
                            cursor.close();
                        } catch (Throwable var13) {
                            var4.addSuppressed(var13);
                        }
                    } else {

                        try {
                            cursor.close();
                        } catch (IOException e) {
                            e.printStackTrace();
                        }

                    }
                }

            }

            return var5;
        });
    }

    @Override
    public void vagueDel(Object key) {
        List keys = this.keys(key + "*");
        this.redisTemplate.delete(keys);
    }

    public Object get(Object key) {
        return this.redisTemplate.opsForValue().get(key);
    }

    public String getString(Object key) {
        try {
            return this.redisTemplate.opsForValue().get(key).toString();
        } catch (Exception var3) {
            return null;
        }
    }

    public List multiGet(Collection keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public void multiSet(Map map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void multiDel(Collection keys) {
        this.redisTemplate.delete(keys);
    }

    public void put(Object key, Object value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    public void put(Object key, Object value, Long exp) {
        this.put(key, value, exp, TimeUnit.SECONDS);
    }

    public void put(Object key, Object value, Long exp, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set(key, value, exp, timeUnit);
    }

    public Boolean remove(Object key) {
        return this.redisTemplate.delete(key);
    }


    public void putHash(Object key, Object hashKey, Object hashValue) {
        this.redisTemplate.opsForHash().put(key, hashKey, hashValue);
    }

    public void putAllHash(Object key, Map map) {
        this.redisTemplate.opsForHash().putAll(key, map);
    }

    public Object getHash(Object key, Object hashKey) {
        return this.redisTemplate.opsForHash().get(key, hashKey);
    }

    public Map<Object, Object> getHash(Object key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    public boolean hasKey(Object key) {
        return this.redisTemplate.opsForValue().get(key) != null;
    }



    public List<Object> keysBlock(String pattern) {
        Set<Object> set = this.redisTemplate.keys(pattern);
        List<Object> list = new ArrayList();
        list.addAll(set);
        return list;
    }



    public Long cumulative(Object key, Object value) {
        HyperLogLogOperations<Object, Object> operations = this.redisTemplate.opsForHyperLogLog();
        return operations.add(key, new Object[]{value});
    }

    public Long counter(Object key) {
        HyperLogLogOperations<Object, Object> operations = this.redisTemplate.opsForHyperLogLog();
        return operations.size(new Object[]{key});
    }

    public List multiCounter(Collection keys) {
        if (keys == null) {
            return new ArrayList();
        } else {
            List<Long> result = new ArrayList();
            Iterator var3 = keys.iterator();

            while(var3.hasNext()) {
                Object key = var3.next();
                result.add(this.counter(key));
            }

            return result;
        }
    }

    public Long mergeCounter(Object... key) {
        HyperLogLogOperations<Object, Object> operations = this.redisTemplate.opsForHyperLogLog();
        return operations.union(key[0], key);
    }

    public Long incr(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.getAndIncrement();
        if (increment == 0L && liveTime > 0L) {
            entityIdCounter.expire(liveTime, TimeUnit.SECONDS);
        }

        return increment;
    }

    public Long incr(String key) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        return entityIdCounter.getAndIncrement();
    }

    public void incrementScore(String sortedSetName, String keyword) {
        this.redisTemplate.opsForZSet().incrementScore(sortedSetName, keyword, 1.0D);
    }

    public void incrementScore(String sortedSetName, String keyword, Integer score) {
        this.redisTemplate.opsForZSet().incrementScore(sortedSetName, keyword, (double)score);
    }



    public Long zRemove(String key, String... value) {
        return this.redisTemplate.opsForZSet().remove(key, value);
    }

    public RedisCache() {
    }
}
