/**
 * 
 */
package cn.com.duiba.tuia.robot.center.api.domain.req;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections.CollectionUtils;
import java.io.Serializable;
import java.util.List;

/**
 * 此类描述的是： 分页查询条件
 */
@Data
@EqualsAndHashCode
public class BaseQueryReq implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 每页10条记录. */
    public static final int   PAGE_SIZE_10     = 10;

    /** 每页20条记录. */
    public static final int   PAGE_SIZE_20     = 20;

    /** 每页50条记录. */
    public static final int   PAGE_SIZE_50     = 50;

    /** 最大每页记录数(10000条). */
    public static final int   PAGE_SIZE_MAX    = 10000;

    /** 起始记录数. */
    private int               rowStart         = 0;

    /** 当前页. */
    private int               pageNumber      = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    private Integer           pageSize;

    /** 排序字段. */
    private String            sort;


    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    private String            order;
    
    /**总计查询*/
    public static final int TOTAL_QUERY=1;
    
    /** 管理员ID，数据权限使用*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private Long            managerId;
    
    /** 管理员能查看的app列表*/
    @ApiModelProperty(value = "管理员ID", required = false)
    private List<Long>      managerAppIds;

    /** 管理员能查看的用户列表*/
    @ApiModelProperty(value = "用户ID集合", required = false)
    private List<Long>      managerMediaIds;
    
    /**总计查询*/
    @ApiModelProperty(value = "总计查询", required = false)
    private Integer         totalQuery;

    /**
     * 是否可查询
     */
    private  boolean        isQuery;

    /**
     *是否拥有超级权限
     */
    private  boolean        isSuperPermission;

    public boolean isQuery(List<Long> ids) {
        return this.isSuperPermission || !CollectionUtils.isEmpty(ids);
    }

    /**
     * 校验分页信息
     */
    public void checkPageParam() {
        if (getPageSize() == null) {
            this.setPageSize(BaseQueryReq.PAGE_SIZE_20);
        }
    }
}
