package cn.com.duiba.tuia.robot.center.api.domain.vo;

import cn.com.duiba.tuia.robot.center.api.domain.utils.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Data
public class SearchVO implements Serializable {
    @ApiModelProperty("起始日期")
    private String startDate;
    @ApiModelProperty("结束日期")
    private String endDate;
    @ApiModelProperty("sql in条件字段")
    private String inColumn;
    @ApiModelProperty("sql in条件字段值")
    private List<String> inColumnValue;
    private Boolean deleteFlag = false;

    public Date getConvertStartDate() {
        return StringUtils.isEmpty(this.startDate) ? null : DateUtil.toDate(this.startDate, "yyyy-MM-dd");
    }

    public Date getConvertEndDate() {
        if (StringUtils.isEmpty(this.endDate)) {
            return null;
        } else {
            Date date = DateUtil.toDate(this.endDate, "yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(5, calendar.get(5) + 1);
            calendar.set(13, -1);
            return calendar.getTime();
        }
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getInColumn() {
        return this.inColumn;
    }

    public List<String> getInColumnValue() {
        return this.inColumnValue;
    }

    public Boolean getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setInColumn(String inColumn) {
        this.inColumn = inColumn;
    }

    public void setInColumnValue(List<String> inColumnValue) {
        this.inColumnValue = inColumnValue;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }


    public SearchVO(String startDate, String endDate, String inColumn, List<String> inColumnValue, Boolean deleteFlag) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.inColumn = inColumn;
        this.inColumnValue = inColumnValue;
        this.deleteFlag = deleteFlag;
    }

    public SearchVO() {
    }
}