package cn.com.duiba.tuia.robot.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.robot.center.api.domain.dos.UserRole;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserRoleService {

    /**
     * 根据用户查看拥有的角色
     *
     * @param userId
     * @return
     */
    List<UserRole> listByUserId(String userId);

    /**
     * 根据用户查看拥有的角色
     *
     * @param userId
     * @return
     */
    List<String> listId(String userId);

    /**
     * 更新用户拥有的角色
     *
     * @param userId    角色
     * @param userRoles 角色权限
     */
    void updateUserRole(String userId, List<UserRole> userRoles);

}
