/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.robot.center.api.domain.utils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    private RedisTemplate<Object, Object> redisTemplate;

    public RedisCache(RedisTemplate<Object, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public List<Object> keys(String pattern) {
        ArrayList<Object> keys = new ArrayList<Object>();
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            keys.add(key);
        });
        return keys;
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            Object var5;
            Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());
            Throwable var4 = null;
            try {
                cursor.forEachRemaining(consumer);
                var5 = null;
            }
            catch (Throwable var14) {
                var4 = var14;
                throw var14;
            }
            finally {
                if (cursor != null) {
                    if (var4 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable var13) {
                            var4.addSuppressed(var13);
                        }
                    } else {
                        try {
                            cursor.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            return var5;
        });
    }

    public void vagueDel(Object key) {
        List<Object> keys = this.keys(key + "*");
        this.redisTemplate.delete(keys);
    }

    public Object get(Object key) {
        return this.redisTemplate.opsForValue().get(key);
    }

    public String getString(Object key) {
        try {
            return this.redisTemplate.opsForValue().get(key).toString();
        }
        catch (Exception var3) {
            return null;
        }
    }

    public List multiGet(Collection keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public void multiSet(Map map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void multiDel(Collection keys) {
        this.redisTemplate.delete(keys);
    }

    public void put(Object key, Object value) {
        this.redisTemplate.opsForValue().set(key, value);
    }

    public void put(Object key, Object value, Long exp) {
        this.put(key, value, exp, TimeUnit.SECONDS);
    }

    public void put(Object key, Object value, Long exp, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set(key, value, exp.longValue(), timeUnit);
    }

    public Boolean remove(Object key) {
        return this.redisTemplate.delete(key);
    }

    public void putHash(Object key, Object hashKey, Object hashValue) {
        this.redisTemplate.opsForHash().put(key, hashKey, hashValue);
    }

    public void putAllHash(Object key, Map map) {
        this.redisTemplate.opsForHash().putAll(key, map);
    }

    public Object getHash(Object key, Object hashKey) {
        return this.redisTemplate.opsForHash().get(key, hashKey);
    }

    public Map<Object, Object> getHash(Object key) {
        return this.redisTemplate.opsForHash().entries(key);
    }

    public boolean hasKey(Object key) {
        return this.redisTemplate.opsForValue().get(key) != null;
    }

    public List<Object> keysBlock(String pattern) {
        Set set = this.redisTemplate.keys((Object)pattern);
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(set);
        return list;
    }

    public Long cumulative(Object key, Object value) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.add(key, new Object[]{value});
    }

    public Long counter(Object key) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.size(new Object[]{key});
    }

    public List multiCounter(Collection keys) {
        if (keys == null) {
            return new ArrayList();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object key : keys) {
            result.add(this.counter(key));
        }
        return result;
    }

    public Long mergeCounter(Object ... key) {
        HyperLogLogOperations operations = this.redisTemplate.opsForHyperLogLog();
        return operations.union(key[0], key);
    }

    public Long incr(String key, long liveTime) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        Long increment = entityIdCounter.getAndIncrement();
        if (increment == 0L && liveTime > 0L) {
            entityIdCounter.expire(liveTime, TimeUnit.SECONDS);
        }
        return increment;
    }

    public Long incr(String key) {
        RedisAtomicLong entityIdCounter = new RedisAtomicLong(key, this.redisTemplate.getConnectionFactory());
        return entityIdCounter.getAndIncrement();
    }

    public void incrementScore(String sortedSetName, String keyword) {
        this.redisTemplate.opsForZSet().incrementScore((Object)sortedSetName, (Object)keyword, 1.0);
    }

    public void incrementScore(String sortedSetName, String keyword, Integer score) {
        this.redisTemplate.opsForZSet().incrementScore((Object)sortedSetName, (Object)keyword, (double)score.intValue());
    }

    public Long zRemove(String key, String ... value) {
        return this.redisTemplate.opsForZSet().remove((Object)key, (Object[])value);
    }
}

