/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月21日上午10:53:48<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqAppStatistics <br/>
 * Function: 媒体数据请求对象. <br/>
 * date: 2016年12月21日 上午10:53:48 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAppStatistics extends ReqDateQuery {

    /**序列号*/
    private static final long serialVersionUID = 2154402586515939055L;

    /** 媒体ID. */
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long       appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = false)
    private String     appName;

    /** 系统平台. */
    @ApiModelProperty(value = "系统平台", required = false)
    private String     platform;

    /** 媒体ID集合. */
    private List<Long> appIds;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the platform.
     *
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * Sets the platform.
     *
     * @param platform the platform
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * Gets the app ids.
     *
     * @return the app ids
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * Sets the app ids.
     *
     * @param appIds the app ids
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
