/**
 * Project Name:media-biz<br>
 * File Name:ReqCreateAdsense.java<br>
 * Package Name:cn.com.duiba.tuia.media.model.req<br>
 * Date:2016年9月26日下午3:38:17<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 创建广告位请求参数 <br/>
 * date: 2016年9月26日 下午3:38:17 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 */
public class ReqCreateSlot implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -538764940887424165L;

    @ApiModelProperty(value = "广告位名称", required = true)
    @NotNull(message = "广告位名称不能为空")
    private String            slotName;

    @ApiModelProperty(value = "选择媒体", required = true)
    @NotNull(message = "广告位必须关联一个媒体")
    private Long              appId;

    @ApiModelProperty(value = "广告位类型", required = true)
    @NotNull(message = "广告位类型不能为空")
    private Integer           slotType;

    @ApiModelProperty(value = "广告位规格")
    private Long              msId;

    @ApiModelProperty(value = "屏蔽策略", required = false)
    private Long              strategyId;

    @ApiModelProperty(value = "媒体账户ID", required = false)
    private Long              mediaId;

    @ApiModelProperty(value = "广告信息流类型", required = false)
    private Long              flowType;
    
    @ApiModelProperty(value = "广告位投放方式", required = true)
    private Integer    		  activityPutWay;

    public String getSlotName() {
        return slotName;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getSlotType() {
        return slotType;
    }

    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public Long getStrategyId() {
        return strategyId;
    }

    public void setStrategyId(Long strategyId) {
        this.strategyId = strategyId;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getFlowType() {
        return flowType;
    }

    public void setFlowType(Long flowType) {
        this.flowType = flowType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

	public Integer getActivityPutWay() {
		return activityPutWay;
	}

	public void setActivityPutWay(Integer activityPutWay) {
		this.activityPutWay = activityPutWay;
	}

}
