/**
 * Project Name:media-api<br>
 * File Name:ReqMediaAppSlotStatisticsDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto.req<br>
 * Date:2016年10月11日下午2:50:40<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName: ReqMediaAppSlotStatisticsDto <br/>
 * date: 2016年10月11日 下午2:50:40 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class ReqMediaAppStatisticsDto extends BaseDateQueryDto implements Serializable {

	/**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -7451007609576531763L;

    @ApiModelProperty(value = "媒体ID", required = false)
    private Long              appId;

    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    @ApiModelProperty(value = "系统平台", required = false)
    private String            platform;

    @ApiModelProperty(value = "媒体账户ID", required = false)
    private Long              mediaId;
    
    /** 广告位id列表 */
	private List<Long>         slotIds;
	
	/** app_id列表 */
	private List<Long>         appIds;

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public List<Long> getSlotIds() {
		return slotIds;
	}

	public void setSlotIds(List<Long> slotIds) {
		this.slotIds = slotIds;
	}

	public List<Long> getAppIds() {
		return appIds;
	}

	public void setAppIds(List<Long> appIds) {
		this.appIds = appIds;
	}

	/**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.6
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.6
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
