/**
 * Project Name:media-manager-biz
 * File Name:ReqStatHourlySort.java
 * Package Name:cn.com.duiba.tuia.media.manager.model.req
 * Date:2017年4月7日下午12:48:47
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqStatHourlySort <br/>
 * Function: 统计每小时排序. <br/>
 * Date:     2017年4月7日 下午12:48:47 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqStatHourlySort {
    
    /** 排序字段(默认排序字段为：gmt_modified). */
    @ApiModelProperty(value = "排序字段", required = false)
    private String          sort;
    
    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    @ApiModelProperty(value = "排序方式", required = false)
    private String          order           = "desc";
    
    /** 拼接字段查询使用*/
    @ApiModelProperty(value = "拼接字段", required = false)
    private String          conditionStr;
    
    
    public String getSort() {
        return sort;
    }

    
    public void setSort(String sort) {
        this.sort = sort;
    }

    
    public String getOrder() {
        return order;
    }

    
    public void setOrder(String order) {
        this.order = order;
    }

    
    public String getConditionStr() {
        return conditionStr;
    }

    
    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

