package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivitySlotDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqCopySlot;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivitySlotDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
public interface RemoteActivitySlotBackendService {

    /**
     * 添加广告位
     * 
     * @param slotIds 广告位ID列表
     * @return Boolean
     */
    DubboResult<Boolean> addSlots(List<Long> slotIds);

    /**
     * 删除广告位
     * 
     * @param slotId 广告位ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteSlot(Long slotId);

    /**
     * 查询广告位列表
     * 
     * @param req 查询条件
     * @return 广告位列表
     */
    DubboResult<PageResultDto<RspActivitySlotDto>> getList(ReqActivitySlotDto req);

    /**
     * 添加广告位时的查询接口
     * 
     * @param ids
     * @return 规格列表
     */
    DubboResult<List<SlotDto>> getSlotByIds(List<Long> ids);

    /**
     * 查询定制广告位
     * 
     * @param slotId id
     * @return 广告位
     */
    DubboResult<RspActivitySlotDto> getById(Long slotId);

    /**
     * 更新定制广告定向模式
     * 
     * @param slotId 广告ID
     * @param directMode 定向模式
     * @return Boolean
     */
    DubboResult<Boolean> updateDirectMode(Long slotId, Integer directMode);

    /**
     * copySlot:(拷贝广告位). <br/>
     *
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> copySlot(ReqCopySlot req, Map<Integer, String> actTypeMap);
}
