/**
 * Project Name:media-manager-biz File Name:ReqActivityStatisticsByPage.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.req Date:2016年12月21日上午11:44:59 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqActivityStatisticsByPage <br/>
 * Function: 广告数据统计. <br/>
 * Date: 2016年12月21日 上午11:44:59 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqActivityStatDataByPage extends ReqPageQuery implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -1158637634156561218L;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    /**
     * 活动ID
     */
    @ApiModelProperty(value = "活动ID", required = false)
    private Long              activityId;

    /**
     * 活动名称
     */
    @ApiModelProperty(value = "活动名称", required = false)
    private String            activityName;

    /**
     * 活动类型
     */
    @ApiModelProperty(value = "活动类型", required = false)
    private String            activityType;

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * activityName.
     *
     * @return the activityName
     * @since JDK 1.6
     */
    public String getActivityName() {
        return activityName;
    }

    /**
     * activityName.
     *
     * @param activityName the activityName to set
     * @since JDK 1.6
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.6
     */
    public String getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.6
     */
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
