/**
 * Project Name:media-biz<br>
 * File Name:ShieldStrategy.java<br>
 * Package Name:cn.com.duiba.tuia.media.domain<br>
 * Date:2016年9月26日下午7:37:21<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 
 * ClassName: ShieldStrategyDto <br/>
 * Function: 屏蔽策略. <br/>
 * date: 2016年12月8日 下午6:46:24 <br/>
 *
 * @author ZFZ
 * @version 
 * @since JDK 1.6
 */
public class ShieldStrategyDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /** 媒体用户ID. */
    private Long              mediaId;

    /** 屏蔽策略名称. */
    private String            strategyName;

    /** 屏蔽行业列表，中间以逗号隔开. */
    private String            shieldIndustries;

    /** 屏蔽广告列表，中间以逗号隔开. */
    private String            advertTagNums;

    /** 屏蔽广告主URL列表， 中间以逗号隔开. */
    private String            shieldUrls;

    /**
     * 
     * Creates a new instance of ShieldStrategyDto.
     *
     * @param mediaId
     * @param strategyName
     * @param shieldIndustries
     * @param shieldUrls
     * @param advertTagNums
     */
    public ShieldStrategyDto(Long mediaId, String strategyName, String shieldIndustries, String shieldUrls,
                             String advertTagNums) {
        super();
        this.mediaId = mediaId;
        this.strategyName = strategyName;
        this.shieldIndustries = shieldIndustries;
        this.shieldUrls = shieldUrls;
        this.advertTagNums = advertTagNums;
    }

    /**
     * 
     * Creates a new instance of ShieldStrategyDto.
     *
     */
    public ShieldStrategyDto() {
        super();
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public String getShieldIndustries() {
        return shieldIndustries;
    }

    public void setShieldIndustries(String shieldIndustries) {
        this.shieldIndustries = shieldIndustries;
    }

    public String getShieldUrls() {
        return shieldUrls;
    }

    public void setShieldUrls(String shieldUrls) {
        this.shieldUrls = shieldUrls;
    }

    public String getAdvertTagNums() {
        return advertTagNums;
    }

    public void setAdvertTagNums(String advertTagNums) {
        this.advertTagNums = advertTagNums;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
