package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

/**
 * 通知（站内信）DTO
 * 
 * @author songjiaxing
 *
 */
public class NoticeDto extends BaseDto {

	private static final long serialVersionUID = 8712355321169783096L;

	/**
	 * 通知主题
	 */
	private String title;

	/**
	 * 发件团队
	 */
	private String sender;

	/**
	 * 定向方式（0：全部，1：定向媒体）
	 */
	private Integer directType;

	/**
	 * 发送时间
	 */
	private Date sendTime;

	/**
	 * 通知内容
	 */
	private String content;

	/**
	 * 收件人(mediaId以‘,’隔开)
	 */
	private String receiver;

	/**
	 * 扩展字段，通知类型（0：系统通知，1：运营通知）
	 */
	private Integer noticeType;

	/**
	 * 是否删除 1：已删除 0：未删除
	 */
	private Integer isDelete;
	
	/**
	 * 读取状态（0：接收未读，1：接收已读）
	 */
	private Integer readStatus;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public Integer getDirectType() {
		return directType;
	}

	public void setDirectType(Integer directType) {
		this.directType = directType;
	}

	public Date getSendTime() {
		return sendTime;
	}

	public void setSendTime(Date sendTime) {
		this.sendTime = sendTime;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public Integer getNoticeType() {
		return noticeType;
	}

	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}

	public Integer getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(Integer isDelete) {
		this.isDelete = isDelete;
	}

	public Integer getReadStatus() {
		return readStatus;
	}

	public void setReadStatus(Integer readStatus) {
		this.readStatus = readStatus;
	}

}
