package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.NoticeDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqNoticeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 通知中心dubbo接口
 * 
 * @author songjiaxing
 *
 */
public interface RemoteNoticeService {

	/**
	 * 添加新通知
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> insertNotice(NoticeDto noticeDto);

	/**
	 * 更新通知 只更新为发送的通知
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> updateNotice(NoticeDto noticeDto);

	/**
	 * 列表查询通知
	 * 
	 * @param params:{'title':通知标题（模糊查询）,'start':开始时间,'end':结束时间,'ids':媒体接收通知列表（
	 *            in）}
	 * @return
	 */
	public DubboResult<List<NoticeDto>> listNotice(ReqNoticeDto params);

	/**
	 * 媒体查询通知列表并接收通知(用于弹窗提醒)
	 * 
	 * @param params:{'createTime'
	 *            : 媒体创建时间,'mediaId':媒体id,'ids':已接受通知id列表（not in）}
	 * @return
	 */
	public DubboResult<List<NoticeDto>> listByMedia(ReqNoticeDto params);

	/**
	 * 媒体更新通知状态为已读
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> update2read(Long mediaId, Long noticeId);

	/**
	 * 媒体更新通知状态为删除
	 * 
	 * @param noticeDto
	 * @return
	 */
	public DubboResult<Integer> update2del(Long mediaId, Long noticeId);

	/**
	 * 根据mediaId查询媒体已接受通知Id列表(提示使用,包含用户删除的通知)
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<Long>> listNidByMedia4tip(Long mediaId);

	/**
	 * 根据mediaId查询媒体已接受通知Id列表(列表使用，不包含用户删除的通知)
	 * 
	 * @param mediaId
	 * @return
	 */
	public DubboResult<List<Long>> listNidByMedia4list(Long mediaId);
}
