package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

public class ActvityAdevertInfoDto implements Serializable {
    /** 仅投放定向列表 */
    public static final int    DIRECT_ADVERT_MODE_ONLY        = 1;

    /** 优先投放定向列表 */
    public static final int    DIRECT_ADVERT_MODE_PRIOR       = 2;

    //广告ID集合
    private List<Long> advertIds;

    //广告定向类型 1仅投放定制广告列表，2优先投放定制广告券列表
    private Integer directAdvertMode;

    public ActvityAdevertInfoDto() {
    }

    public ActvityAdevertInfoDto(List<Long> advertIds, Integer directAdvertMode) {
        this.advertIds = advertIds;
        this.directAdvertMode = directAdvertMode;
    }

    public List<Long> getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    public Integer getDirectAdvertMode() {
        return directAdvertMode;
    }

    public void setDirectAdvertMode(Integer directAdvertMode) {
        this.directAdvertMode = directAdvertMode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
