/**
 * Project Name:ssp-center-api
 * File Name:RemoteStrategyService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月6日上午10:55:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.ManagerShieldStrategyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteStrategyService <br/>
 * Function: 管理端屏蔽策略. <br/>
 * Date:     2017年6月6日 上午10:55:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteManagerShieldStrategyService {

    /**
     * 
     * insert:(新增屏蔽标签). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> insert(ManagerShieldStrategyDto param);
    
    /**
     * 
     * update:(修改屏蔽标签). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> update(ManagerShieldStrategyDto param);
    
   
    DubboResult<ManagerShieldStrategyDto> selectById(Long id);
    
    /**
     * 
     * selectListBySlotIds:(批量查询管理端屏蔽标签). <br/>
     *
     * @author guyan
     * @param slotIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ManagerShieldStrategyDto>> selectListBySlotIds(List<Long> slotIds);
    
    /**
     * 
     * selectBySlotId:(通过广告位ID查询管理端屏蔽标签). <br/>
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<ManagerShieldStrategyDto> selectBySlotId(Long slotId);
    
    
}

