package cn.com.duiba.tuia.ssp.center.api.remote;


import cn.com.duiba.tuia.ssp.center.api.dto.SystemConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 活动引擎活动域名配置
 */
public interface RemoteSystemConfigService {

    /**
     * 根据tuiaKey删除对应记录
     * @param tuiaKey
     * @return
     */
    DubboResult<Boolean> deleteByKey(String tuiaKey);

    /**
     * 更新或插入一条域名记录
     * @param record
     * @return
     */
    DubboResult<Boolean> insertOrUpdateSelective(SystemConfigDto record);

    /**
     * 根据tuiaKey查询一条记录
     * @param tuiaKey
     * @return
     */
    DubboResult<SystemConfigDto> selectByKey(String tuiaKey);

    /**
     * 根据tuiaKey查询对应的tuiaValue
     * @param tuiaKey
     * @return
     */
    DubboResult<String> selectTuiaValueByKey(String tuiaKey);

    /**
     * 查询所有的记录
     * @return
     */
    DubboResult<List<SystemConfigDto>> selectAll();
}
